/* -*- c++ -*- */
#ifndef AKAXISO2_XML_SCHEMA_GENERATOR_H__
#define AKAXISO2_XML_SCHEMA_GENERATOR_H__

#include <akaxiso2/akaxiso2.h>
#include <akaxiso2/util/iosfwd.h>
#include <vector>

namespace osx {

  void generate_schema(const std::string &docname, std::ostream &ostm);

  struct schema_generator : public aka::serializer {
    explicit schema_generator();
    explicit schema_generator(const std::string &encoding);
    virtual ~schema_generator();
    void add_docname(const std::string &docname);
    void generate_schema(std::ostream &ostm);

  private:
    typedef std::vector<aka::qname> qnames;
    qnames docnames_;
    aka::id_type target_ns_;
    typedef std::set<const aka::element_op*> opset;
    opset to_generate_;
    opset generated_;

    void write_schema();
    void write_element_declaration(const aka::qname &docname, const aka::element_props &props);

    void write_definition(const aka::element_op &op);
    void write_child(const aka::element_props &props);

    void write_complexType_definition(const aka::element_op &op);
    void write_simpleType_definition(const aka::element_op &op);

    void write_sequence(const aka::element_op &op);
    void write_choice(const aka::element_op &op);
    void write_all(const aka::element_op &op);
    void write_simpleContent(const aka::element_op &op);

    void write_occurrence(const aka::occurrence &occ);

    void write(const std::string &text);

  };
  
}

#endif
