// -*- c++ -*-
#ifndef AKAXISO_ALL_H__
#define AKAXISO_ALL_H__

#include <akaxiso/classes/simpletype.h>
#include <akaxiso/classes/attribute.h>
#include <akaxiso/classes/type_registory.h>
#include <akaxiso/classes/ptrmember.h>
#include <akaxiso/classes/memberdef.h>

#include <vector>

namespace aka2 {


  template<class L>
  class all_op_dispatcher : public all_op {
  public:
    virtual schematype_id get_schematype() const { return all_id; }
    virtual const qname& get_typename() const { return L::typename_; }
    /** creatable */
    virtual void* create() const { return L::create(); }
    virtual void destroy(void *elm) const { L::destroy(elm); }
    virtual bool equals(const void *lhs, const void *rhs) const {
      return L::equals(lhs, rhs);
    }
    virtual void copy(void *dest, const void *src) const {
      L::copy(dest, src);
    }

    /** attribute_info getter. */
    virtual const attribute_types *get_attribute_types() const { 
      return &L::attribute_types_; 
    }
    /** all_info getter. */
    virtual const member_map &get_member_map() const {
      return L::member_map_;
    }
  };


  template<class T, class L=xiso::leaf<T> >
  class all : public attributes<L, T>,
	      public memberdef<L, T> {
  public:
    typedef T value_type;

    virtual ~all(){}

    static member_type* register_membertype(const member_type &mtype) { 
      std::pair<member_map::iterator, bool> res = 
    	member_map_.insert(member_map::value_type(mtype.get_name(), mtype)); 
      if (!res.second)
	      throw internal_error();
      return &res.first->second;
    } 

    static void initialize() {
      if (!system_type_registory().add(L()))
      	return;
      member_map_.clear();
      attribute_types_.clear();
      L l; l.model(); // VC6 does not accept L().model();
    }

    static void uninitialize() {
      member_map_.clear();
      attribute_types_.clear();
    }

    static T* create() { 
      T* t = new T;
      all_construct(t, dispatcher_);
      return t;
    }
    static void destroy(void *elm) { 
      all_destruct(elm, dispatcher_);
      delete static_cast<T*>(elm); 
    }
    static bool equals(const void *lhs, const void *rhs) {
      return all_equals(lhs, rhs, dispatcher_);
    }
    static void copy(void *dest, const void *src) {
      all_copy(dest, src, dispatcher_);
    }

    static element_op* get_attribute_dispatcher() { return &dispatcher_; } 
    static default_op* create_default_op() { return 0; }

    static member_map member_map_;
    static qname typename_;
    static all_op_dispatcher<L> dispatcher_;

    static void xmltype(const char *name) {
      typeinfo_.set_name(qname(name));
    }

    static bool acceptable(schematype_id id) {
      return 
	(id == sequence_id) ||
	(id == choice_id) ||
	(id == simpletype_id) ||
	(id == ptrmember_id) ||
	(id == simplecontent_id);
    }
  };
  
  template<class T, class L>
  member_map all<T, L>::member_map_;

  template<class T, class L>
  qname all<T, L>::typename_;

  template<class T, class L>
  all_op_dispatcher<L> all<T, L>::dispatcher_;

}

#endif
