/*  -*- c++ -*- */
#ifndef AKAXISO_CLASSES_FIXED_H__
#define AKAXISO_CLASSES_FIXED_H__

namespace aka2 {

  struct fixed_op : public element_op {
    fixed_op(const simpletype_op &eop) : value_op_(eop){}
    virtual ~fixed_op() {}
    virtual schematype_id get_schematype() const { return fixed_id; }
    virtual const qname& get_typename() const { return value_op_.get_typename();  }
    virtual void* create() const { return 0; }
    virtual void destroy(void *) const { }
    virtual bool equals(const void *lhs, const void *rhs) const { return true; }
    virtual void copy(void *dest, const void *src) const { }
    virtual const attribute_types *get_attribute_types() const { return 0; }
    virtual const simpletype_op& get_value_op() const {
      return value_op_;
    }
 private:
    const simpletype_op &value_op_;
  };

  struct fixed_getter : public member_getter {
    fixed_getter(simpletype_op *et) : op_(*et) {}
    virtual void* get_member(void *element) const { return 0; }
    virtual const void* get_member(const void* element) const { return 0; }
    virtual const element_op* get_op() const { return &op_; }
  protected:
    int offset_;
    fixed_op op_;
  };

  inline fixed_getter *create_fixed_getter(simpletype_op *op) {
    return new fixed_getter(op);
  }
  
}

#endif
