/* -*- c++ -*- */
#ifndef AKAXISO_NAMESPACES_H__
#define AKAXISO_NAMESPACES_H__

#include <akaxiso/classes/types.h>
#include <map>
#include <string>

namespace aka2 {

  typedef long id_type;
  extern const id_type unregistered_token;
  extern const id_type empty_token;

  class namespace_map {
    typedef std::map<id_type, std::string> urimap_type;
    typedef std::map<std::string, id_type> idmap_type;
  public:
    namespace_map() : current_id_(1) {}
    const id_type register_namespace_uri(const std::string &uri);
    const std::string &get_namespace_uri(const id_type id) const;
    const id_type get_namespace_id(const std::string &uri) const;

    void initialize();
    void uninitialize();
  private:
    id_type current_id_;

    urimap_type urimap_;
    idmap_type idmap_;
  };


  class prefix_map {
    typedef std::map<id_type, std::string> prefixmap_type;
    typedef std::map<const std::string, id_type> idmap_type;
  public:
    typedef prefixmap_type::const_iterator const_iterator;

    const_iterator begin() const { return prefixmap_.begin(); }
    const_iterator end() const { return prefixmap_.end(); }

    void assign_prefix(const std::string &prefix, const id_type id);
    void clear_prefix(const std::string &prefix);
    const id_type get_prefix_id(const std::string &prefix) const;
    const std::string &get_prefix(const id_type id) const;
    void initialize();
    void uninitialize();

  private:
    prefixmap_type prefixmap_;
    idmap_type idmap_;
  };

  void initialize_namespaces();
  void uninitialize_namespaces();

}

#endif
