// -*- c++ -*-
#ifndef AKAXISO_MEMBERARRAY_HANDLER_H__
#define AKAXISO_MEMBERARRAY_HANDLER_H__

#include <akaxiso/parser/handler.h>

namespace aka2 {

  class array_handler : public handler {
  public:
    array_handler(const qname &tagname, void *ma, int depth,
		  const array_op &aop, const occurence &occ,
		  bool is_element,
		  parser_context &context);
    virtual ~array_handler(){}
    virtual parse_result query_element(const qname &tagname, const attribute_values &attrs, 
				       const global_attributes &gattrs);
    virtual parse_result end_element(const qname &tagname);
    virtual bool parse_entity(const std::string &entity, const global_attributes &gattrs);

    virtual memberpair get_element();
    virtual void receive_child(const memberpair &mpair);

    virtual bool can_skip();
    virtual void abort(); 

  private:
    parse_result parse_element(const qname &tagname, const attribute_values &attrs, 
			       const global_attributes &gattrs);
    parse_result find_particle(const qname &tagname, const attribute_values &attrs, 
			       const global_attributes &gattrs);

    void *array_;
    void *e_;
    const array_op &aop_;
    const occurence &occurence_;
    bool is_element_;
    int count_;
  };

}

#endif

