/** -*- c++ -*- */
#ifndef AKAXISO_PARSER_FIXED_HANDLER_H__
#define AKAXISO_PARSER_FIXED_HANDLER_H__

#include <akaxiso/parser/handler.h>
#include <akaxiso/classes/membertype.h>


namespace aka2 {

  class fixed_handler : public handler {
  public:
    fixed_handler(const qname& tagname, int depth, const member_type &mtype,
		  parser_context &context);

    virtual ~fixed_handler(){}
    virtual parse_result query_element(const qname &tagname, const attribute_values &attrs, 
				       const global_attributes &gattrs);
    virtual parse_result end_element(const qname &tagname);
    virtual bool parse_entity(const std::string &entity, const global_attributes &gattrs);

    virtual memberpair get_element();
    virtual void receive_child(const memberpair &e);
    virtual bool can_skip();
    virtual void abort();
  private:
    const member_type &mtype_;
  };


  class fixed_array_handler : public handler {
  public:
    fixed_array_handler(const qname& tagname, int depth, const member_type &mtype,
			parser_context &context);

    virtual ~fixed_array_handler(){}
    virtual parse_result query_element(const qname &tagname, const attribute_values &attrs, 
				       const global_attributes &gattrs);
    virtual parse_result end_element(const qname &tagname);
    virtual bool parse_entity(const std::string &entity, const global_attributes &gattrs);

    virtual memberpair get_element();
    virtual void receive_child(const memberpair &e);
    virtual bool can_skip();
    virtual void abort();
  private:
    const member_type &mtype_;
    size_t count_;
  };



}

#endif
