#include <akaxiso/content_model.h>
#include "schema.h"
#include "schema_xiso.h"


using namespace xs;

void maxOccursLeaf::write_text(const void *e, std::ostream &ostm,
			       const aka::global_attributes &gattrs) {
  const long &v = *static_cast<const long*>(e);
  if (v == aka::unbounded)
    ostm << "unbounded";
  else
    ostm << v;
}

void maxOccursLeaf::read_text(void *e, std::istringstream &istm, 
			      const aka::global_attributes &gattrs) {
  long &v = *static_cast<long*>(e);
  if (istm.rdbuf()->str() == "unbounded") {
    v = aka::unbounded;
    return;
  }
  istm >> v;
  if (istm.fail())
    throw aka::internal_error();
}



void xs::define_schemadoc() {
  aka::xmlns("xs", NS_XMLSCHEMA);
  aka::doctype("xs:schema", SchemaLeaf(), aka::occurence(1, aka::unbounded));
}
