#include <akaxiso/akaxiso.h>
#include <akaxiso/content_model.h>
#include <iostream>

int main() {
#ifdef USE_XERCESC
  xercesc::XMLPlatformUtils::Initialize();
#endif

  aka::initialize();
  aka::doctype("long_document", xiso::leaf<long>());

  {
    aka::xml_parser parser;
    aka::document doc;

    try  {
      doc = parser.parse_stdin();
    }
    catch (std::exception &e) {
      std::cerr << "Parse error detected." << std::endl
		<< e.what() << std::endl;
      exit(1);
    }

    std::cout << "Document (" << doc.get_name() << ") is parsed." << std::endl;
    long *val = aka::root_cast<long>(doc);
    std::cout << "Value " << *val << std::endl;
  }
    
  aka::uninitialize();
#ifdef USE_XERCESC
  xercesc::XMLPlatformUtils::Terminate();
#endif
}
