#include <akaxiso/akaxiso.h>
#include <akaxiso/content_model.h>
#include <iostream>

int main() {
#ifdef USE_XERCESC
  xercesc::XMLPlatformUtils::Initialize();
#endif

  aka::initialize();
  aka::doctype("smallest_document", aka::nill_leaf());
  aka::doctype("long_document", xiso::leaf<long>());

  {
    aka::xml_parser parser;
    aka::document doc = parser.parse_stdin();
    std::cout << "Document (" << doc.get_name() << ") is parsed." << std::endl;
    
    if (aka::document_of(doc, "smallest_document"))
      std::cout << "Content is nill." << std::endl;
    else if (aka::document_of(doc, "long_document")) {
      long *val = aka::root_cast<long>(doc);
      std::cout << "Content is long value of " << *val << "." << std::endl;
    }

  }
    
  aka::uninitialize();
#ifdef USE_XERCESC
  xercesc::XMLPlatformUtils::Terminate();
#endif
}
