#include <akaxiso/akaxiso.h>
#include <akaxiso/content_model.h>
#include <iostream>

#include "tutorial7.h"

int main() {
#ifdef USE_XERCESC
  xercesc::XMLPlatformUtils::Initialize();
#endif

  aka::initialize();
  instantiate_xiso();

  {
    aka::xml_parser parser;
    aka::document doc = parser.parse_stdin();
    std::cout << "Document (" << doc.get_name() << ") is parsed." << std::endl;
    
    assert(aka::document_of(doc, "janken"));

    const janken_choice &root = *aka::root_cast<janken_choice>(doc);

    for (janken_choice::const_iterator it = root.begin();
	 it != root.end(); ++it) {
      aka::qname tagname = it->get_name();
      if (tagname == aka::qname("goo"))
	std::cout << tagname << " is " 
		  << aka::item_cast<goo>(*it).explanation_ << '.' << std::endl;
      else if (tagname == aka::qname("choki"))
	std::cout << tagname << " is " 
		  << aka::item_cast<choki>(*it).explanation_ << '.' << std::endl;
      else if (tagname == aka::qname("pa"))
	std::cout << tagname << " is " 
		  << aka::item_cast<pa>(*it).explanation_ << '.' << std::endl;
    }

  }
    
  aka::uninitialize();
#ifdef USE_XERCESC
  xercesc::XMLPlatformUtils::Terminate();
#endif
}
