#include "akaxiso.h"
#include "classes/namespaces.h"
#include "classes/document.h"
#include "classes/type_registory.h"
#include "classes/closure.h"

using namespace aka2;


namespace {
  namespace_map namespaces_;
  global_attributes gattrs_;
  document_factory docfactory_;
  type_registory type_registory_;
}


global_attributes &aka2::system_global_attributes() {
  return gattrs_;
}

namespace_map & aka2::namespaces() {
  return namespaces_;
}

document_factory& aka2::system_document_factory() {
  return docfactory_;
} 

type_registory &aka2::system_type_registory() {
  return type_registory_;
}


void aka2::initialize() {
  namespaces_.initialize();
  gattrs_.initialize();
  docfactory_.initialize();
  type_registory_.initialize();
  enclose_op::initialize();
  disclose_op::initialize();
}

void aka2::uninitialize() {
  namespaces_.uninitialize();
  gattrs_.uninitialize();
  docfactory_.uninitialize();
  type_registory_.uninitialize();
}


