/* -*- c++ -*- */
#ifndef AKAXISO_CLOSURE_H__
#define AKAXISO_CLOSURE_H__

#include <akaxiso/classes/traits.h>

#include <assert.h>

namespace aka2 {

  class enclose_op : public element_op {
  public:
    virtual schematype_id get_schematype() const { return enclose_id; }
    virtual const qname& get_typename() const { return typename_; }
    virtual const attribute_types* get_attribute_types() const {
      return 0;
    }
    virtual void* create() const { assert(!"Must not be called."); return 0;}
    virtual void destroy(void *) const { assert(!"Must not be called."); }
    virtual bool equals(const void *lhs, const void *rhs) const { return true; }
    virtual void copy(void *dest, const void *src) const { }
    static enclose_op op_;
    static qname typename_;
    static void initialize() {
        typename_ = qname("#enclose");
    }
  };



  class disclose_op : public element_op {
  public:
    virtual schematype_id get_schematype() const { return disclose_id; }
    virtual const qname& get_typename() const { return typename_; }
    virtual const attribute_types* get_attribute_types() const { 
      return 0; 
    }
    virtual void* create() const { assert(!"Must not be called."); return 0;}
    virtual void destroy(void *) const { assert(!"Must not be called."); }
    virtual bool equals(const void *lhs, const void *rhs) const { return true; }
    virtual void copy(void *dest, const void *src) const { }
    static disclose_op op_;
    static qname typename_;
    static void initialize() {
        typename_ = qname("#disclose");
    }
  };

}

#endif
