#include <akaxiso/akaxiso.h>
#include "schema.h"

int main() {
#ifdef USE_XERCESC
  xercesc::XMLPlatformUtils::Initialize();
#endif

 aka::initialize();
  xs::define_schemadoc();
  // Parse

  aka::xml_parser parser;
  aka::document doc;
  try {
    doc = parser.parse_stdin();
  }
  catch (const aka::parse_exception &e) {
    std::cerr << e.what() << std::endl;
    std::cerr << "Parse error detected.  Abort immediately." << std::endl;
    exit(1);
  }
   catch ( ... ) {
     std::cerr << "Unhandled parse error detected.  Abort immediatedly." << std::endl;
     exit(1);
   }

  aka::xml_serializer ser;
  ser.serialize(doc, std::cout);


  aka::uninitialize();
#ifdef USE_XERCEC
  XMLPlatformUtils::Terminate();
#endif

}
