/* -*- c++ -*- */
#ifndef AKAXISO_DEEP_PTR_H__
#define AKAXISO_DEEP_PTR_H__

/**
 * @file akaxiso/classes/deep_ptr.h
 * @author Shin'ya MORINO (smorino@users.sourceforge.jp)
 */

namespace aka2 {

template <class T>
class deep_ptr {
public:
  typedef T value_type;

  explicit deep_ptr(T* ptr = 0) : ptr_(ptr) {}
  ~deep_ptr() {
    delete ptr_;
  }

  deep_ptr(const deep_ptr &rhs) {
    if (rhs.ptr_ == 0)
      ptr_ = 0;
    else
      ptr_ = new T(*rhs.ptr_);
  }

  void reset(T* ptr = 0) {
    delete ptr_;
    ptr_ = ptr;
  }

  const deep_ptr<T>& operator=(const deep_ptr<T> &rhs) {
    delete ptr_;
    if (rhs.ptr_ == 0)
      ptr_ = 0;
    else
      ptr_ = new T(*rhs.ptr_);
    return *this;
  }

  bool operator ==(const deep_ptr<T> &rhs) {
    return ptr_ == rhs.ptr_;
  }


  T*& get() { return ptr_; }
  T* get() const { return ptr_; }

  T& operator*() const { return *ptr_; }
  T* operator->() const { return ptr_; }

private:  
  T* ptr_;
};

} // namespace aka2

#endif /* AKAXISO_DEEP_PTR_H__ */
