/* -*- c++ -*- */
#ifndef AKAXISO_CONFIGURATION_H__
#define AKAXISO_CONFIGURATION_H__

#include <akaxiso/config.h>

/** Compilers */

#ifdef __GNUG__
# define TYPENAME typename
# define LONGLONG long long
# define ULONGLONG unsigned long long
# define USE_OWN_USTRING 1
# if (__GNUC__ == 3) && (__GNUC_MINOR__ <= 3)
#  define IMPLEMENT_CHAR_TRAITS 1
# endif
# if (__GNUC__ == 2)
#  define MISSING_SSTREAM_IN_IOSFWD 1
# endif
# if defined(__i386__)
#  define __LITTLE_ENDIAN_COMPUTER__ 1
# endif
#define __BBL_USING_STATIC_TABLE__ 1 // babel
#endif

#ifdef _MSC_VER
# pragma warning( disable : 4786 )
# include <windows.h>
# if _MSC_VER >= 1300
#  define TYPENAME typename
# else
#  define TYPENAME
# endif
# ifndef LONGLONG
#  define LONGLONG _int64
# endif
# ifndef ULONGLONG
#  define ULONGLONG unsigned _int64
# endif
# ifdef _M_IX86
#  define __LITTLE_ENDIAN_COMPUTER__
# endif
#define __BBL_USING_STATIC_TABLE__ 1 // babel
#endif

#ifdef __BORLANDC__
# include <windows.h>
# define TYPENAME typename
# if __BORLANDC__ >= 0x0560
#  define LONGLONG long long
#  define ULONGLONG unsigned long long
# endif
# ifdef USE_XERCESC
#  pragma link "XercesLib.lib"
# endif
# define __LITTLE_ENDIAN_COMPUTER__ 1
#define __BBL_USING_STDMAP_TABLE__ 1 // babel.  Can be changed to STATIC_TABLE?!!!
#endif

/* Make sure to define _WIN32 for BCB. */
#if defined(__WIN32__) /* BCB style */ && !defined(_WIN32)
# define _WIN32 1
#endif

#if defined(__linux__)
# define WCHAR_T aka2::uchar_t
# define USE_PTHREADS 1
# if !defined(UTF8) && !defined(EUCJP)
#  define EUCJP
# endif
#endif

/* babel '#define's. */
#define __BBL_USE_SELECTORS__      1
#define __UNICODE_CHAR_SIZE_2__    1

#ifndef WCHAR_T
#define WCHAR_T wchar_t
#endif

#ifdef EUCJP
# define DEFAULT_ENCODING "eucJP"
# define __USING_EUC__ 1 // Babel
# undef EUCJP
#endif

#ifdef UTF8
# define DEFAULT_ENCODING "UTF-8"
# define __USING_UTF8__ 1 // Babel
# undef UTF8
#endif

/* Default encoding for WIN32 */
#if defined(_WIN32)
# define DEFAULT_ENCODING "Shift_JIS"
# define __USING_SJIS__ 1 // Babel
#endif

#if !defined(DEFAULT_ENCODING)
# error "Default encoding is not specified."
#endif

#if !defined(__LITTLE_ENDIAN_COMPUTER__) && !defined(__BIG_ENDIAN_COMPUTER__)
# error "Endian is not specified."
#endif

#endif
