/* -*- c++ -*- */
#ifndef AKAXISO_XERCES_PARSER_H__
#define AKAXISO_XERCES_PARSER_H__

#include <akaxiso/parser.h>

#ifdef USE_XERCESC
#include <xercesc/sax2/SAX2XMLReader.hpp>
#endif

namespace aka2 {

  class xerces_parser : public parser {
  public:
    xerces_parser();

#ifdef USE_XERCESC
    virtual ~xerces_parser() {}

    virtual document parse(std::istream &istm);
    virtual document parse(const char *document);
    virtual document parse(const std::string &document);
    virtual document parse_stdin();
    virtual document parse_file(const std::string &filepath);

  private:
    document parse_internal(xercesc::InputSource &src, const std::string &source_name);
#endif
  };

} // namespace aka2

#endif /* AKAXISO_XERCES_PARSER_H__ */
