#include "project.h"
#include "projectmap.h"
#include "basket.h"
#include "all_test.h"
#include "model_array.h"

#include <akaxiso/akaxiso.h>
#include <iostream>
#include <stdlib.h>

void parse() {
  
  aka::xml_parser parser;

  aka::document doc;
  try {
    doc = parser.parse_stdin();
  }
  catch ( const std::exception &e) {
    std::cerr << e.what() << std::endl;
    exit(1);
  }
  catch ( ... ) {
    std::cerr << "Parse error detected." << std::endl;
    exit(1);
  }

  if (aka::document_of(doc, "cuppa:project") ||
      aka::document_of(doc, "cuppa:sequence_map") ||
      aka::document_of(doc, "cuppa:simplecontents_map") ||
      aka::document_of(doc, "basket") ||
      aka::document_of(doc, "params") ||
      aka::document_of(doc, "model_arrays")) {
    std::cout << "Document(\"" << doc.get_name() << "\") parsed." << std::endl;
  }
  else {
    std::cout << "Unknown document(\"" << doc.get_name() << "\")." << std::endl;
    exit(1);
  }

  aka::xml_serializer ser;
  ser.serialize(doc, std::cout);
  
}


void usage() {
  std::cout << "project [-h]" << std::endl
            << "  -h : show this usage." << std::endl;
}


int main(int argc, const char* argv[]){

  aka::initialize();

  // Initialize Project classes defined in project.h.
  aka::xmlns("cuppa", "http://unittest.org/akaxiso/memberlist");
  aka::doctype("cuppa:project", xiso::leaf<pj::Team>());

  aka::doctype("cuppa:simplecontents_map", pj::OrderedSimpleContentTeamLeaf());
  aka::doctype("cuppa:sequence_map", pj::OrderedSequenceTeamLeaf());

  aka::doctype("basket", xiso::leaf<basket>());

  aka::doctype("params", xiso::leaf<params>());

  aka::doctype("model_arrays", xiso::leaf<root>());

  parse();

  aka::uninitialize();
  return 0;
}
