#include <akaxiso/schema/schema_xiso.h>
#include <akaxiso/schema/schema.h>
#include <iostream>

int main(int argc, const char *argv[]) {
  aka::initialize();
  xs::instantiate_xiso();

  aka::document doc;
  try {
    aka::xml_parser parser;
    doc = parser.parse_file(argv[1]);
  }
  catch ( const std::exception &e ) {
    std::cerr << e.what() << std::endl;
    exit(1);
  }
  
  aka::xml_serializer ser;
  ser.serialize(doc, std::cout);

  aka::uninitialize();
}
