/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class ESP32_SPIFF_WRITEBlock
extends TranslatorBlock {
    public ESP32_SPIFF_WRITEBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        String ret = "";
        TranslatorBlock tb = this.getRequiredTranslatorBlockAtSocket(0);
        String path = tb.toCode();
        tb = this.getRequiredTranslatorBlockAtSocket(1);
        String value = tb.toCode();
        this.translator.addHeaderFile("FS.h");
        this.translator.addHeaderFile("SPIFFS.h");
        this.translator.addDefinitionCommand("FILE writefile;");
        this.translator.addSetupCommand(" if(!SPIFFS.begin()){");
        this.translator.addSetupCommand("   Serial.println(\"SPIFFS Mount Failed\");");
        this.translator.addSetupCommand("   return;");
        this.translator.addSetupCommand(" }");
        this.translator.addSetupCommand(" ");
        this.translator.addSetupCommand("    readfile = SPIFFS.open(" + path + ");");
        this.translator.addSetupCommand("       if(!readfile || readfile.isDirectory()){");
        this.translator.addSetupCommand("        Serial.println(\"Failed to open file for reading\");");
        this.translator.addSetupCommand("    }");
        this.translator.addSetupCommand("    if(writefile.print(message)){");
        this.translator.addSetupCommand("        Serial.println(\"File written\");");
        this.translator.addSetupCommand("    } else {");
        this.translator.addSetupCommand("        Serial.println(\"Write failed\");");
        this.translator.addSetupCommand("    }");
        this.translator.addSetupCommand("");
        this.translator.addSetupCommand("    writefile.close();");
        return ret;
    }
}

