/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblocks;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.codeblocks.BlockLinkChecker;
import edu.mit.blocks.codeblockutil.Sound;
import edu.mit.blocks.codeblockutil.SoundManager;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.Workspace;
import edu.mit.blocks.workspace.WorkspaceEvent;

public class BlockLink {
    private final Workspace workspace;
    private static Sound clickSound;
    private Long plugBlockID;
    private Long socketBlockID;
    private Long lastPlugBlockID;
    private BlockConnector plug;
    private BlockConnector socket;
    private static Long lastPlugID;
    private static Long lastSocketID;
    private static BlockConnector lastPlug;
    private static BlockConnector lastSocket;
    private static BlockLink lastLink;

    private BlockLink(Workspace workspace, Block block1, Block block2, BlockConnector socket1, BlockConnector socket2) {
        boolean isPlug2;
        this.workspace = workspace;
        boolean isPlug1 = block1.hasPlug() && block1.getPlug() == socket1 || block1.hasBeforeConnector() && block1.getBeforeConnector() == socket1;
        boolean bl = isPlug2 = block2.hasPlug() && block2.getPlug() == socket2 || block2.hasBeforeConnector() && block2.getBeforeConnector() == socket2;
        if (!(isPlug1 ^ isPlug2)) {
            assert (false);
        } else if (isPlug1) {
            this.plug = socket1;
            this.socket = socket2;
            this.plugBlockID = block1.getBlockID();
            this.socketBlockID = block2.getBlockID();
        } else {
            this.plug = socket2;
            this.socket = socket1;
            this.plugBlockID = block2.getBlockID();
            this.socketBlockID = block1.getBlockID();
        }
        lastPlugID = this.plugBlockID;
        lastSocketID = this.socketBlockID;
        lastPlug = this.plug;
        lastSocket = this.socket;
        this.lastPlugBlockID = Block.NULL;
    }

    public BlockConnector getPlug() {
        return this.plug;
    }

    public BlockConnector getSocket() {
        return this.socket;
    }

    public Long getPlugBlockID() {
        return this.plugBlockID;
    }

    public Long getSocketBlockID() {
        return this.socketBlockID;
    }

    public Long getLastBlockID() {
        return this.lastPlugBlockID;
    }

    public void connect() {
        if (this.socket.hasBlock()) {
            this.lastPlugBlockID = this.socket.getBlockID();
            Block plugBlock = this.workspace.getEnv().getBlock(this.lastPlugBlockID);
            BlockConnector plugBlockPlug = BlockLinkChecker.getPlugEquivalent(plugBlock);
            if (plugBlockPlug != null && plugBlockPlug.hasBlock()) {
                Block socketBlock = this.workspace.getEnv().getBlock(plugBlockPlug.getBlockID());
                BlockLink link = BlockLink.getBlockLink(this.workspace, plugBlock, socketBlock, plugBlockPlug, this.socket);
                link.disconnect();
                this.workspace.notifyListeners(new WorkspaceEvent(this.workspace, this.workspace.getEnv().getRenderableBlock(socketBlock.getBlockID()).getParentWidget(), link, 6));
            }
        }
        if (this.plug.hasBlock()) {
            throw new RuntimeException("trying to link a plug that's already connected somewhere.");
        }
        this.plug.setConnectorBlockID(this.socketBlockID);
        this.socket.setConnectorBlockID(this.plugBlockID);
        RenderableBlock socketRB = this.workspace.getEnv().getRenderableBlock(this.socketBlockID);
        socketRB.blockConnected(this.socket, this.plugBlockID);
        if (clickSound != null) {
            clickSound.play();
        }
    }

    public void disconnect() {
        this.plug.setConnectorBlockID(Block.NULL);
        this.socket.setConnectorBlockID(Block.NULL);
    }

    public static BlockLink getBlockLink(Workspace workspace, Block block1, Block block2, BlockConnector socket1, BlockConnector socket2) {
        if (!(block1.getBlockID().equals(lastPlugID) && block2.getBlockID().equals(lastSocketID) && socket1.equals(lastPlug) && socket2.equals(lastSocket) || block2.getBlockID().equals(lastPlugID) && block1.getBlockID().equals(lastSocketID) && socket2.equals(lastPlug) && socket1.equals(lastSocket))) {
            lastLink = new BlockLink(workspace, block1, block2, socket1, socket2);
        }
        return lastLink;
    }

    public String toString() {
        return "BlockLink(Plug: " + this.plugBlockID + ", Socket: " + this.socketBlockID + ")";
    }

    static {
        try {
            clickSound = SoundManager.loadSound("/edu/mit/blocks/codeblocks/click.wav");
        }
        catch (Exception e) {
            System.out.println("Error initializing sounds.  Continuing...");
        }
    }
}

