/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.workspace;

import edu.mit.blocks.codeblockutil.CQueryField;
import edu.mit.blocks.workspace.SearchableContainer;
import edu.mit.blocks.workspace.SearchableElement;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SearchBar {
    private final CQueryField searchPanel;
    private final JTextField searchBar;
    private final String defaultText;
    private Set<SearchableContainer> containerSet = new HashSet<SearchableContainer>();
    private Map<SearchableContainer, Set<SearchableElement>> searchResults = new HashMap<SearchableContainer, Set<SearchableElement>>();
    private Timer searchUpdater;
    private static final int SEARCH_UPDATER_DELAY = 5000;
    private Timer searchThrottle;
    private static final int SEARCH_THROTTLE_DELAY = 250;
    private SearchRange searchRange;

    public SearchBar(String defaultText, String tooltip, final Component defaultComponent) {
        this.defaultText = defaultText;
        this.searchPanel = new CQueryField();
        this.searchBar = this.searchPanel.getQueryField();
        this.searchBar.setToolTipText(tooltip);
        this.searchBar.setColumns(12);
        this.resetSearchBar();
        this.searchBar.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SearchBar.this.readySearchBar();
            }

            @Override
            public void focusLost(FocusEvent e) {
                SearchBar.this.resetSearchBar();
            }
        });
        this.searchBar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    SearchBar.this.searchBar.setText("");
                    defaultComponent.requestFocusInWindow();
                }
            }
        });
        this.searchBar.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (SearchBar.this.searchBar.getText().equals(SearchBar.this.defaultText)) {
                    return;
                }
                if (e.getOffset() == 0 || e.getOffset() + e.getLength() == SearchBar.this.searchBar.getText().length()) {
                    SearchBar.this.performSearch(SearchRange.REMOVE_FROM_FOUND);
                } else {
                    SearchBar.this.performSearch(SearchRange.CHECK_ALL);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (SearchBar.this.searchBar.getText().equals("")) {
                    SearchBar.this.performSearch(SearchRange.CHECK_ALL);
                } else if (e.getOffset() == 0 || e.getOffset() == SearchBar.this.searchBar.getText().length()) {
                    SearchBar.this.performSearch(SearchRange.ADD_FROM_NOT_FOUND);
                } else {
                    SearchBar.this.performSearch(SearchRange.CHECK_ALL);
                }
            }
        });
        this.searchUpdater = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchBar.this.searchThrottle != null && !SearchBar.this.searchThrottle.isRunning()) {
                    SearchBar.this.searchRange = SearchRange.CHECK_ALL;
                    SearchBar.this.performSearchTimerHandler();
                }
            }
        });
        this.searchUpdater.start();
    }

    public JComponent getComponent() {
        return this.searchPanel;
    }

    public Iterable<SearchableElement> getSearchResults(SearchableContainer container) {
        Set<SearchableElement> results = this.searchResults.get(container);
        if (results == null) {
            results = Collections.emptySet();
            return results;
        }
        return Collections.unmodifiableSet(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSearchableContainer(SearchableContainer searchable) {
        SearchBar searchBar = this;
        synchronized (searchBar) {
            this.containerSet.add(searchable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSearchableContainer(SearchableContainer searchable) {
        SearchBar searchBar = this;
        synchronized (searchBar) {
            this.containerSet.remove(searchable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        SearchBar searchBar = this;
        synchronized (searchBar) {
            this.searchResults.clear();
            this.containerSet.clear();
        }
    }

    private void resetSearchBar() {
        if (this.searchBar.getText().trim().equals("")) {
            Font font = this.searchBar.getFont();
            this.searchBar.setFont(new Font(font.getName(), 2, font.getSize()));
            this.searchBar.setForeground(Color.GRAY);
            this.searchBar.setText(this.defaultText);
        }
    }

    private void readySearchBar() {
        if (this.defaultText.equals(this.searchBar.getText())) {
            this.searchBar.setText("");
            Font font = this.searchBar.getFont();
            this.searchBar.setFont(new Font(font.getName(), 0, font.getSize()));
            this.searchBar.setForeground(Color.BLACK);
        } else {
            this.searchBar.selectAll();
        }
    }

    private void clearSearchResults() {
        for (Set<SearchableElement> foundElements : this.searchResults.values()) {
            for (SearchableElement element : foundElements) {
                element.updateInSearchResults(false);
            }
            for (SearchableContainer container : this.searchResults.keySet()) {
                container.updateContainsSearchResults(false);
            }
        }
        this.searchResults.clear();
    }

    private void performSearch(SearchRange range) {
        if (this.searchRange == null) {
            this.searchRange = range;
        }
        if (!this.searchRange.equals((Object)range)) {
            this.searchRange = SearchRange.CHECK_ALL;
        }
        if (this.searchThrottle == null) {
            this.searchThrottle = new Timer(250, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchBar.this.performSearchTimerHandler();
                }
            });
            this.searchThrottle.setRepeats(false);
        }
        if (this.searchThrottle.isRunning()) {
            this.searchThrottle.restart();
        } else {
            this.searchThrottle.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSearchTimerHandler() {
        Set<SearchableElement> foundElements;
        HashSet<SearchableContainer> containers;
        if (this.searchBar.getText().equals("")) {
            this.clearSearchResults();
            return;
        }
        SearchRange range = this.searchRange;
        this.searchRange = null;
        Iterator iterator = this;
        synchronized (iterator) {
            containers = new HashSet<SearchableContainer>(this.containerSet);
        }
        if (range == SearchRange.ADD_FROM_NOT_FOUND || range == SearchRange.CHECK_ALL) {
            for (SearchableContainer container : containers) {
                foundElements = this.searchResults.get(container);
                if (foundElements == null) {
                    foundElements = new HashSet<SearchableElement>();
                    this.searchResults.put(container, foundElements);
                }
                for (SearchableElement searchableElement : container.getSearchableElements()) {
                    if (foundElements.contains(searchableElement) || !searchableElement.getKeyword().toUpperCase().contains(this.searchBar.getText().toUpperCase())) continue;
                    foundElements.add(searchableElement);
                    searchableElement.updateInSearchResults(true);
                }
                if (foundElements.isEmpty()) continue;
                container.updateContainsSearchResults(true);
            }
        }
        if (range == SearchRange.REMOVE_FROM_FOUND || range == SearchRange.CHECK_ALL) {
            for (SearchableContainer container : containers) {
                foundElements = this.searchResults.get(container);
                if (foundElements == null) continue;
                HashSet<SearchableElement> elementsToRemove = new HashSet<SearchableElement>();
                for (SearchableElement element : foundElements) {
                    if (element.getKeyword().toUpperCase().contains(this.searchBar.getText().toUpperCase())) continue;
                    elementsToRemove.add(element);
                    element.updateInSearchResults(false);
                }
                foundElements.removeAll(elementsToRemove);
                if (!foundElements.isEmpty()) continue;
                container.updateContainsSearchResults(false);
            }
        }
    }

    private static enum SearchRange {
        CHECK_ALL,
        REMOVE_FROM_FOUND,
        ADD_FROM_NOT_FOUND;

    }
}

