/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.workspace.typeblocking;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.codeblocks.BlockLink;
import edu.mit.blocks.codeblocks.BlockLinkChecker;
import edu.mit.blocks.workspace.Workspace;

public class LinkFinderUtil {
    protected static BlockLink connectBlocks(Workspace workspace, Block child, Block parent) {
        BlockLink link;
        BlockLink link2;
        if (LinkFinderUtil.invalidBlock(child)) {
            return null;
        }
        if (LinkFinderUtil.invalidBlock(parent)) {
            return null;
        }
        if (parent.hasPlug()) {
            for (BlockConnector socket : child.getSockets()) {
                if (LinkFinderUtil.invalidConnector(socket) || (link2 = BlockLinkChecker.canLink(workspace, child, parent, socket, parent.getPlug())) == null) continue;
                return link2;
            }
        }
        if (child.hasPlug()) {
            for (BlockConnector socket : parent.getSockets()) {
                if (socket == null) continue;
                if (child.isInfix()) {
                    if (parent.isInfix() || (link2 = BlockLinkChecker.canLink(workspace, parent, child, socket, child.getPlug())) == null) continue;
                    return link2;
                }
                link2 = BlockLinkChecker.canLink(workspace, parent, child, socket, child.getPlug());
                if (link2 == null) continue;
                return link2;
            }
        }
        if (child.hasBeforeConnector()) {
            for (BlockConnector socket : parent.getSockets()) {
                if (LinkFinderUtil.invalidConnector(socket) || (link2 = BlockLinkChecker.canLink(workspace, parent, child, socket, child.getBeforeConnector())) == null) continue;
                return link2;
            }
        }
        if (child.hasBeforeConnector() && parent.hasAfterConnector() && (link = BlockLinkChecker.canLink(workspace, parent, child, parent.getAfterConnector(), child.getBeforeConnector())) != null) {
            return link;
        }
        if (child.hasAfterConnector() && parent.hasBeforeConnector() && (link = BlockLinkChecker.canLink(workspace, child, parent, child.getAfterConnector(), parent.getBeforeConnector())) != null) {
            return link;
        }
        if (parent.hasPlug()) {
            return LinkFinderUtil.connectBlocks(workspace, child, workspace.getEnv().getBlock(parent.getPlugBlockID()));
        }
        return null;
    }

    private static boolean invalidBlock(Block block) {
        if (block == null) {
            return true;
        }
        return LinkFinderUtil.invalidBlock(block.getBlockID());
    }

    private static boolean invalidBlock(Long blockID) {
        if (blockID == null) {
            return true;
        }
        return blockID == Block.NULL;
    }

    private static boolean invalidConnector(BlockConnector connector) {
        if (connector == null) {
            return true;
        }
        return connector.hasBlock();
    }
}

