/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.BitSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Filter;

public class CachingWrapperFilter
extends Filter {
    private Filter filter;
    private transient Map cache;

    public CachingWrapperFilter(Filter filter) {
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitSet bits(IndexReader reader) throws IOException {
        if (this.cache == null) {
            this.cache = new WeakHashMap();
        }
        Map map = this.cache;
        synchronized (map) {
            BitSet cached = (BitSet)this.cache.get(reader);
            if (cached != null) {
                return cached;
            }
        }
        BitSet bits = this.filter.bits(reader);
        Map map2 = this.cache;
        synchronized (map2) {
            this.cache.put(reader, bits);
        }
        return bits;
    }
}

