/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.activities.ws.ActivityEnabler;
import org.eclipse.ui.internal.activities.ws.ActivityMessages;

public class ActivitiesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button activityPromptButton;
    private IWorkbench workbench;
    private ActivityEnabler enabler;

    protected void createActivityPromptPref(Composite composite) {
        this.activityPromptButton = new Button(composite, 32);
        this.activityPromptButton.setText(ActivityMessages.getString("activityPromptButton"));
        this.activityPromptButton.setToolTipText(ActivityMessages.getString("activityPromptToolTip"));
        this.activityPromptButton.setFont(composite.getFont());
        this.setActivityButtonState();
    }

    private void setActivityButtonState() {
        this.activityPromptButton.setSelection(this.getPreferenceStore().getBoolean("shouldPromptForEnablement"));
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        this.createActivityPromptPref(composite);
        GridData data = new GridData(768);
        this.activityPromptButton.setLayoutData((Object)data);
        data = new GridData(1808);
        this.enabler = new ActivityEnabler(this.workbench.getActivitySupport());
        this.enabler.createControl(composite).setLayoutData((Object)data);
        return composite;
    }

    public void init(IWorkbench aWorkbench) {
        this.workbench = aWorkbench;
        this.setPreferenceStore(WorkbenchPlugin.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        this.enabler.updateActivityStates();
        this.getPreferenceStore().setValue("shouldPromptForEnablement", this.activityPromptButton.getSelection());
        return true;
    }

    protected void performDefaults() {
        this.enabler.restoreDefaults();
        this.activityPromptButton.setSelection(this.getPreferenceStore().getDefaultBoolean("shouldPromptForEnablement"));
        super.performDefaults();
    }
}

