/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.commons.swt.ui.tree;

import java.util.List;
import java.util.Vector;
import org.eclipse.swt.graphics.Image;

public class TreeObject {
    private Image image;
    private boolean expand;
    private String text;
    private TreeObject parent;
    private List childrenList = new Vector();

    public boolean isExpanded() {
        return this.expand;
    }

    public void setExpanded(boolean expand) {
        this.expand = expand;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public TreeObject getParent() {
        return this.parent;
    }

    public void setParent(TreeObject parent) {
        this.parent = parent;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void addTreeObject(TreeObject object) {
        object.setParent(this);
        this.childrenList.add(object);
    }

    public int countTreeObjects() {
        return this.childrenList.size();
    }

    public TreeObject getTreeObjectAt(int index) {
        return (TreeObject)this.childrenList.get(index);
    }

    public TreeObject[] getTreeObjects() {
        return this.childrenList.toArray(new TreeObject[this.childrenList.size()]);
    }

    public void removeTreeObject(TreeObject object) {
        this.childrenList.remove(object);
    }

    public void upTreeObject(TreeObject object) {
        int index = this.checkIndex(object);
        if (index > 0) {
            this.childrenList.remove(object);
            this.childrenList.add(index - 1, object);
        }
    }

    public void downTreeObject(TreeObject object) {
        int index = this.checkIndex(object);
        if (index < this.childrenList.size() - 1) {
            this.childrenList.remove(object);
            this.childrenList.add(index + 1, object);
        }
    }

    public void topTreeObject(TreeObject object) {
        int index = this.checkIndex(object);
        if (index > 0) {
            this.childrenList.remove(object);
            this.childrenList.add(0, object);
        }
    }

    public void bottomTreeObject(TreeObject object) {
        int index = this.checkIndex(object);
        if (index < this.childrenList.size() - 1) {
            this.childrenList.remove(object);
            this.childrenList.add(this.childrenList.size(), object);
        }
    }

    private int checkIndex(TreeObject object) {
        TreeObject[] objects = this.getTreeObjects();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] == object) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void removeAllTreeObject() {
        this.childrenList.removeAll(this.childrenList);
    }

    public boolean contain(TreeObject itemObject) {
        int i = 0;
        while (i < this.countTreeObjects()) {
            if (this.getTreeObjectAt(i) == itemObject) {
                return true;
            }
            this.getTreeObjectAt(i).contain(itemObject);
            ++i;
        }
        return false;
    }

    public void addTreeObject(TreeObject object, int index) {
        object.setParent(this);
        this.childrenList.add(index, object);
    }

    public int indexOf(TreeObject object) {
        return this.childrenList.indexOf(object);
    }
}

