/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.expressions.Assert;
import org.eclipse.core.internal.expressions.Expressions;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class EqualsExpression
extends Expression {
    private Object fExpectedValue;

    public EqualsExpression(Object expectedValue) {
        Assert.isNotNull(expectedValue);
        this.fExpectedValue = expectedValue;
    }

    public EqualsExpression(IConfigurationElement element) throws CoreException {
        String value = element.getAttribute("value");
        Expressions.checkAttribute("value", value);
        this.fExpectedValue = Expressions.convertArgument(value);
    }

    public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
        Object element = context.getDefaultVariable();
        return EvaluationResult.valueOf(element.equals(this.fExpectedValue));
    }
}

