/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.expressions.ExpressionMessages;
import org.eclipse.core.internal.expressions.ExpressionStatus;
import org.eclipse.core.internal.expressions.Expressions;
import org.eclipse.core.internal.expressions.Property;
import org.eclipse.core.internal.expressions.TypeExtensionManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;

public class TestExpression
extends Expression {
    private String fNamespace;
    private String fProperty;
    private Object[] fArgs;
    private Object fExpectedValue;
    private static final String ATT_PROPERTY = "property";
    private static final String ATT_ARGS = "args";
    private static final TypeExtensionManager fgTypeExtensionManager = new TypeExtensionManager("propertyTesters");
    static /* synthetic */ Class class$0;

    public TestExpression(IConfigurationElement element) throws CoreException {
        String property = element.getAttribute(ATT_PROPERTY);
        int pos = property.lastIndexOf(46);
        if (pos == -1) {
            throw new CoreException((IStatus)new ExpressionStatus(300, ExpressionMessages.getString("TestExpression.no_name_space")));
        }
        this.fNamespace = property.substring(0, pos);
        this.fProperty = property.substring(pos + 1);
        this.fArgs = Expressions.getArguments(element, ATT_ARGS);
        this.fExpectedValue = Expressions.convertArgument(element.getAttribute("value"));
    }

    public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
        Object element = context.getDefaultVariable();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.System");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(element)) {
            String str = System.getProperty(this.fProperty);
            if (str == null) {
                return EvaluationResult.FALSE;
            }
            return EvaluationResult.valueOf(str.equals(this.fArgs[0]));
        }
        Property property = fgTypeExtensionManager.getProperty(element, this.fNamespace, this.fProperty);
        if (!property.isInstantiated()) {
            return EvaluationResult.NOT_LOADED;
        }
        return EvaluationResult.valueOf(property.test(element, this.fArgs, this.fExpectedValue));
    }

    public String toString() {
        StringBuffer args = new StringBuffer();
        int i = 0;
        while (i < this.fArgs.length) {
            Object arg = this.fArgs[i];
            if (arg instanceof String) {
                args.append('\'');
                args.append(arg);
                args.append('\'');
            } else {
                args.append(arg.toString());
            }
            if (i < this.fArgs.length - 1) {
                args.append(", ");
            }
            ++i;
        }
        return "<test property=\"" + this.fProperty + (this.fArgs.length != 0 ? "\" args=\"" + args + "\"" : "\"") + (this.fExpectedValue != null ? "\" value=\"" + this.fExpectedValue + "\"" : "\"") + "/>";
    }
}

