/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.speech;

import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.audio.JavaClipAudioPlayer;
import com.sun.speech.freetts.audio.SingleFileAudioPlayer;
import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VoicePlayer {
    AudioPlayer player;
    public static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.speech.VoicePlayer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void play(Voice voice, String text) {
        this.player = new JavaClipAudioPlayer();
        voice.setAudioPlayer(this.player);
        voice.speak(VoicePlayer.removeWhilteSpaceEnd(text));
        this.player.close();
    }

    public void cancel() {
        this.player.pause();
        this.player.cancel();
    }

    public void write(Voice voice, String text, File file) {
        if (text.length() == 0) {
            log.info((Object)"text empty");
            return;
        }
        String wiredPath = file.getAbsolutePath();
        if (wiredPath.endsWith(".wav")) {
            wiredPath = wiredPath.substring(0, wiredPath.length() - 4);
        }
        this.player = new SingleFileAudioPlayer(wiredPath, AudioFileFormat.Type.WAVE);
        voice.setAudioPlayer(this.player);
        String speakText = VoicePlayer.removeWhilteSpaceEnd(text);
        log.trace((Object)("'" + speakText + "'"));
        if (speakText.length() == 0) {
            log.info((Object)"speakText empty");
            return;
        }
        voice.speak(speakText);
        this.player.close();
        if (!file.getAbsolutePath().endsWith(".wav")) {
            new File(String.valueOf(wiredPath) + ".wav").renameTo(file);
        }
    }

    public static String removeWhilteSpaceEnd(String text) {
        while (text.length() > 0) {
            if (!Character.isWhitespace(text.charAt(text.length() - 1))) break;
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }
}

