/*
 * Decompiled with CFR 0.152.
 */
package rcp_gtalk;

import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class GtalkPlugin
extends AbstractUIPlugin {
    private static GtalkPlugin plugin;
    private ResourceBundle resourceBundle;

    public GtalkPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("rcp_gtalk.Rcp_gtalkPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static GtalkPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = GtalkPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public File getGtalkExecuteFile() {
        File base = this.getGtalkDirectory();
        if (base == null) {
            return null;
        }
        if (Platform.getOS().equals("win32")) {
            return new File(base, "gtalk.exe");
        }
        return new File(base, "gtalk");
    }

    public File getGtalkDirectory() {
        File file;
        if (System.getProperty("gtalk.home") != null) {
            return new File(System.getProperty("gtalk.home"));
        }
        if (Platform.getOS().equals("win32") ? (file = new File("C:\\Program Files\\galatea4win\\engine\\SSM\\gtalk-1.0")).exists() && file.isDirectory() : (file = new File("/usr/local/bin/galatea4win/engine/SSM/gtalk-1.0")).exists() && file.isDirectory()) {
            return file;
        }
        File underPluginMbrola = new File(this.toPluginDir(this), "galatea4win/engine/SSM/gtalk-1.0");
        if (underPluginMbrola.exists() && underPluginMbrola.isDirectory()) {
            return underPluginMbrola;
        }
        return null;
    }

    private File toPluginDir(AbstractUIPlugin plugin) {
        return new File(Platform.getInstallLocation().getURL().getPath(), "plugins/" + plugin.getBundle().getSymbolicName() + "_" + plugin.getBundle().getHeaders().get("Bundle-Version"));
    }
}

