/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.commons.audio;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AudioUtils {
    public static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.commons.audio.AudioUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public static long countByteAt(AudioFormat format, long millisecond) {
        if (millisecond == 0L) {
            return 0L;
        }
        return AudioUtils.countByteAt(format.getFrameRate(), format.getSampleSizeInBits(), format.getChannels(), millisecond);
    }

    public static long countByteAt(double framerate, int samplebit, int channel, long millisecond) {
        if (millisecond == 0L) {
            return 0L;
        }
        long rateIndex = (long)(framerate / 1000.0 * (double)millisecond);
        return rateIndex * (long)samplebit / 8L * (long)channel;
    }

    public static void appendSilenceWave(OutputStream output, double framerate, int samplebit, int channel, long millisecond) {
        try {
            long bt = AudioUtils.countByteAt(framerate, samplebit, channel, millisecond);
            int buffersize = 10240;
            BufferedOutputStream bout = new BufferedOutputStream(output, buffersize);
            byte[] buff = new byte[buffersize];
            long num = bt / (long)buffersize;
            int mod = (int)(bt % (long)buffersize);
            int i = 0;
            while ((long)i < num) {
                bout.write(buff);
                ++i;
            }
            bout.write(new byte[mod]);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void repeatFile(File inputFile, File outputFile, int repeatTime) {
        log.trace((Object)("input " + inputFile.getAbsolutePath() + " outputFile " + outputFile + " repeat " + repeatTime));
        try {
            BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(outputFile));
            byte[] buffer = new byte[10240];
            int i = 0;
            while (i < repeatTime) {
                int read;
                BufferedInputStream binput = new BufferedInputStream(new FileInputStream(inputFile));
                while ((read = binput.read(buffer)) != -1) {
                    bout.write(buffer, 0, read);
                }
                binput.close();
                ++i;
            }
            bout.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void repeatWave(File inputFile, File outputFile, int repeatTime, long silentmillisecond, boolean silencelast) throws IOException {
        try {
            File tmpFile = File.createTempFile("appendSilence", ".wav");
            log.trace((Object)("create tmp:" + tmpFile.getAbsolutePath()));
            FileOutputStream fout = new FileOutputStream(tmpFile);
            FileInputStream input = new FileInputStream(inputFile);
            AudioInputStream audioInputStream = null;
            audioInputStream = AudioSystem.getAudioInputStream(inputFile);
            AudioFormat audioFormat = audioInputStream.getFormat();
            int readBytes = 0;
            byte[] bytedata = new byte[10280];
            long readedByte = 0L;
            while (readBytes != -1) {
                readBytes = audioInputStream.read(bytedata, 0, bytedata.length);
                if (readBytes < 0) continue;
                fout.write(bytedata, 0, readBytes);
            }
            audioInputStream.close();
            ((InputStream)input).close();
            fout.close();
            File repeatTmpFile = File.createTempFile("repeatWave", ".wav");
            log.trace((Object)("create tmp:" + repeatTmpFile.getAbsolutePath()));
            FileOutputStream repeatOut = new FileOutputStream(repeatTmpFile);
            int i = 0;
            while (i < repeatTime) {
                AudioUtils.appendFile(tmpFile, repeatOut);
                if (i != repeatTime - 1 || silencelast) {
                    AudioUtils.appendSilenceWave(repeatOut, audioFormat.getFrameRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), silentmillisecond);
                }
                ++i;
            }
            repeatOut.close();
            AudioInputStream clipInput = new AudioInputStream(new FileInputStream(repeatTmpFile), audioFormat, repeatTmpFile.length() / 4L);
            FileOutputStream output = new FileOutputStream(outputFile);
            int writtenBytes = -1;
            writtenBytes = AudioSystem.write(clipInput, AudioFileFormat.Type.WAVE, output);
            log.trace((Object)("write:" + writtenBytes));
            clipInput.close();
            output.close();
            boolean result = tmpFile.delete();
            log.trace((Object)("delte tmp:" + result));
            result = repeatTmpFile.delete();
            log.trace((Object)("delte repatTmp:" + result));
        }
        catch (UnsupportedAudioFileException e) {
            log.fatal((Object)"", (Throwable)e);
        }
    }

    private static void appendFile(File tmpFile, FileOutputStream repeatOut) {
        try {
            int b;
            BufferedOutputStream bout = new BufferedOutputStream(repeatOut);
            BufferedInputStream binput = new BufferedInputStream(new FileInputStream(tmpFile));
            while ((b = binput.read()) != -1) {
                bout.write(b);
            }
            binput.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void appendFile(File tmpFile, File repeatTmpFile) {
        try {
            int b;
            FileOutputStream fout = new FileOutputStream(repeatTmpFile, true);
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            BufferedInputStream binput = new BufferedInputStream(new FileInputStream(tmpFile));
            while ((b = binput.read()) != -1) {
                bout.write(b);
            }
            binput.close();
            bout.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void appendSilenceWave(File inputFile, long millisecond) {
        try {
            File tmpFile = File.createTempFile("appendSilence", ".wav");
            log.trace((Object)("create tmp:" + tmpFile.getAbsolutePath()));
            FileOutputStream fout = new FileOutputStream(tmpFile);
            FileInputStream input = new FileInputStream(inputFile);
            AudioInputStream audioInputStream = null;
            audioInputStream = AudioSystem.getAudioInputStream(inputFile);
            AudioFormat audioFormat = audioInputStream.getFormat();
            int readBytes = 0;
            byte[] bytedata = new byte[10280];
            long readedByte = 0L;
            while (readBytes != -1) {
                readBytes = audioInputStream.read(bytedata, 0, bytedata.length);
                if (readBytes < 0) continue;
                fout.write(bytedata, 0, readBytes);
            }
            audioInputStream.close();
            AudioUtils.appendSilenceWave(fout, audioFormat.getFrameRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), millisecond);
            fout.close();
            AudioInputStream clipInput = new AudioInputStream(new FileInputStream(tmpFile), audioFormat, tmpFile.length() / 4L);
            FileOutputStream output = new FileOutputStream(inputFile);
            int writtenBytes = -1;
            writtenBytes = AudioSystem.write(clipInput, AudioFileFormat.Type.WAVE, output);
            log.trace((Object)("write:" + writtenBytes));
            clipInput.close();
            output.close();
            boolean result = tmpFile.delete();
            log.trace((Object)("delte tmp:" + result));
        }
        catch (FileNotFoundException e) {
            log.fatal((Object)"", (Throwable)e);
        }
        catch (UnsupportedAudioFileException e) {
            log.fatal((Object)"", (Throwable)e);
        }
        catch (IOException e) {
            log.fatal((Object)"", (Throwable)e);
        }
        catch (Exception e) {
            log.fatal((Object)"", (Throwable)e);
        }
    }
}

