/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.audiotools.spectrogram.views;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.ViewPart;
import org.jpn.xucker.rcp.audiotools.QuickConverter;
import org.jpn.xucker.rcp.audiotools.spectrogram.SpectrogramImageFigure;
import org.jpn.xucker.rcp.audiotools.spectrogram.SpectrogramPainter;
import org.jpn.xucker.rcp.audiotools.spectrogram.views.KHZMemoryPainter;
import org.jpn.xucker.rcp.audiotools.tools.ToolsUtil;
import org.jpn.xucker.rcp.snack.Snack_rcpPlugin;
import org.jpn.xucker.rcp.ui.BufferedImagePainter;
import org.jpn.xucker.rcp.ui.DefaultZoom;
import org.jpn.xucker.rcp.ui.FigureMemoryComposite;
import org.jpn.xucker.rcp.ui.GraphMemoryLabelProvider;
import org.jpn.xucker.rcp.ui.NumberLabelProvider;
import org.jpn.xucker.rcp.ui.ProgressMonitor;
import org.jpn.xucker.rcp.ui.SimpleGraphMemoryPainter;
import org.jpn.xucker.rcp.ui.Zoom;
import org.jpn.xucker.rcp.ui.ZoomChangeListener;
import org.jpn.xucker.snack.Formant;
import org.jpn.xucker.snack.FormantFigure;
import org.jpn.xucker.snack.FormantParser;
import org.jpn.xucker.snack.SnackExecuter;
import org.jpn.xucker.snack.Spectrogram;

public class AudioGraphView
extends ViewPart {
    public static Log log;
    public static String ID_VIEW;
    private SnackExecuter snackExecuter;
    private FigureMemoryComposite imageMemoryComposite;
    private SpectrogramPainter painter;
    private SpectrogramImageFigure spectrogramImageFigure;
    private FormantFigure formantFigure = new FormantFigure();
    int compositeHeight = 512;
    int basePersecond = 400;
    DefaultZoom defaultZoom = new DefaultZoom();
    double pixelMillisecond = 2.5;
    private KHZMemoryPainter khzMemoryPainter;
    private boolean spectrogram;
    private boolean formant = true;
    private int graphTop = 24;
    private int graphLeft = 46;
    private boolean fit = true;
    private int samplerate = 48000;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.rcp.audiotools.spectrogram.views.AudioGraphView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.jpn.xucker.rcp.audiotools.spectrogram.views.AudioGraphView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID_VIEW = clazz2.getName();
    }

    public boolean isFormant() {
        return this.formant;
    }

    public void setFormant(boolean formant) {
        log.trace((Object)("formant:" + formant));
        this.formant = formant;
        this.formantFigure.setVisible(formant);
    }

    public boolean isSpectrogram() {
        return this.spectrogram;
    }

    public void setSpectrogram(boolean spectrogram) {
        this.spectrogram = spectrogram;
    }

    public void createPartControl(Composite parent) {
        this.snackExecuter = new SnackExecuter(Snack_rcpPlugin.getDefault().getSnackExecuterDirectory().getAbsolutePath());
        this.imageMemoryComposite = new FigureMemoryComposite(parent, 0, this.graphTop, this.graphLeft);
        this.painter = new SpectrogramPainter(parent.getDisplay());
        SimpleGraphMemoryPainter vpainter = this.imageMemoryComposite.getVerticalGraphPainter();
        vpainter.setPerMain((double)this.compositeHeight / 12.0);
        vpainter.setGraphPlus(true);
        this.khzMemoryPainter = new KHZMemoryPainter();
        this.khzMemoryPainter.setHeight(this.compositeHeight);
        this.khzMemoryPainter.setGraphPlus(false);
        this.khzMemoryPainter.setVerticalGraph(true);
        this.imageMemoryComposite.setMaxVerticalValue(this.compositeHeight);
        this.imageMemoryComposite.setVerticalMemoryStart(this.compositeHeight - 1);
        this.imageMemoryComposite.setVscrollLabelProvider((GraphMemoryLabelProvider)this.khzMemoryPainter);
        this.imageMemoryComposite.getVerticalMemoryCanvas().setGraphMemoryPainter((SimpleGraphMemoryPainter)this.khzMemoryPainter);
        this.imageMemoryComposite.getHorizontalGraphPainter().setPerMain(80.0);
        this.setHorizontalMemoryValue();
        this.spectrogramImageFigure = new SpectrogramImageFigure();
        this.imageMemoryComposite.getContents().add((IFigure)this.spectrogramImageFigure);
        this.spectrogramImageFigure.setZoom(this.defaultZoom.getZoom(), 1.0);
        this.spectrogramImageFigure.add((IFigure)this.formantFigure);
        this.setFit(true);
        this.defaultZoom.setWrap(true);
        this.defaultZoom.addZoomChangeListener((ZoomChangeListener)new ZoomChangeRepaint());
        this.defaultZoom.setZoomIndex(4);
        MouseZoom mouseListener = new MouseZoom();
        this.imageMemoryComposite.getCanvas().addMouseListener((org.eclipse.swt.events.MouseListener)mouseListener);
        Transfer[] types = new Transfer[]{FileTransfer.getInstance()};
        int operations = 3;
        DropTarget target2 = new DropTarget((Control)this.imageMemoryComposite.getCanvas(), operations);
        target2.setTransfer(types);
        target2.addDropListener((DropTargetListener)new DropMonitor());
    }

    public void setHorizontalMemoryValue() {
        this.imageMemoryComposite.setHscrollLabelProvider((GraphMemoryLabelProvider)new NumberLabelProvider((int)((double)this.basePersecond / this.defaultZoom.getZoom()), 4800));
    }

    public IProgressMonitor getProgressMonitor() {
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        StatusLineManager lineManager = workbenchWindow.getStatusLineManager();
        return lineManager.getProgressMonitor();
    }

    public void exportImage(File file) {
        ExportImage exp = new ExportImage(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), file);
        exp.start();
    }

    public void setFocus() {
    }

    public void setFit(boolean bool) {
        log.trace((Object)("fit:" + bool));
        this.formantFigure.setFit(bool);
        this.spectrogramImageFigure.setFit(bool);
        if (bool) {
            this.khzMemoryPainter.setSamplerate(this.samplerate);
        } else {
            this.khzMemoryPainter.setSamplerate(48000);
        }
        this.updateDraw();
    }

    public void updateDraw() {
        this.imageMemoryComposite.getScalableLayeredPane().setScale(1.0);
        this.imageMemoryComposite.redraw(0, 0, this.imageMemoryComposite.getClientArea().width, this.imageMemoryComposite.getClientArea().height, true);
        log.trace((Object)("spectrogram:" + this.spectrogramImageFigure.getSize()));
        log.trace((Object)("formant:" + this.formantFigure.getSize()));
    }

    public void setAudioData(Spectrogram spectrogram, Image spectrogramImage, Formant[] formants) {
        this.spectrogramImageFigure.setSpectrogramImage(spectrogramImage);
        this.spectrogramImageFigure.setSamplerate(this.samplerate);
        FormantParser.normalize(formants, 2);
        this.formantFigure.setFormants(formants);
        log.trace((Object)"formant-resize:");
        this.formantFigure.resize();
        this.formantFigure.setSampleRate(this.samplerate);
        int margin = (int)((spectrogram.toMillisecond() - Formant.toMillisecond(formants)) / this.pixelMillisecond / 2.0);
        this.formantFigure.setMarginX(margin);
        this.updateDraw();
    }

    public void setAudio(File file) {
        File importFile = null;
        if (this.isWavFile(file)) {
            importFile = file;
        } else {
            QuickConverter converter = new QuickConverter();
            if (converter.canConvert(file, "wav")) {
                try {
                    importFile = File.createTempFile("tmp", ".wav");
                    log.trace((Object)("convert:" + importFile.getAbsolutePath()));
                    converter.convert(file, importFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (importFile != null) {
            OpenSpectrogram progress = new OpenSpectrogram(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), importFile);
            try {
                new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, true, (IRunnableWithProgress)progress);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            log.warn((Object)("not supported file " + file.getAbsolutePath()));
        }
    }

    private boolean isWavFile(File file) {
        return ToolsUtil.getExtension(file).toLowerCase().equals("wav");
    }

    public class ZoomChangeRepaint
    implements ZoomChangeListener {
        public void zoomUp(Zoom arg0) {
        }

        public void zoomDown(Zoom arg0) {
        }

        public void zoomChange(Zoom zoom) {
            AudioGraphView.this.setHorizontalMemoryValue();
            AudioGraphView.this.spectrogramImageFigure.setZoom(zoom.getZoom(), 1.0);
            AudioGraphView.this.formantFigure.setWzoom(zoom.getZoom());
            AudioGraphView.this.updateDraw();
        }
    }

    public class DropMonitor
    extends DropTargetAdapter {
        public void dragEnter(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            block0: {
                String[] files = (String[])event.data;
                int i = 0;
                if (i >= files.length) break block0;
                AudioGraphView.this.setAudio(new File(files[0]));
            }
        }
    }

    public class MouseZoom
    implements MouseListener,
    org.eclipse.swt.events.MouseListener {
        public void mousePressed(MouseEvent arg0) {
        }

        public void mouseReleased(MouseEvent arg0) {
        }

        public void mouseDoubleClicked(MouseEvent arg0) {
            AudioGraphView.this.defaultZoom.zoomUp();
        }

        public void mouseDoubleClick(org.eclipse.swt.events.MouseEvent e) {
            AudioGraphView.this.defaultZoom.zoomUp();
        }

        public void mouseDown(org.eclipse.swt.events.MouseEvent e) {
        }

        public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
        }
    }

    public class ExportImage
    extends Thread
    implements ProgressMonitor {
        private File file;
        private Shell shell;
        private IProgressMonitor monitor;
        int maxprogress;

        public ExportImage(Shell shell, File file) {
            this.file = file;
            this.shell = shell;
            this.monitor = AudioGraphView.this.getProgressMonitor();
            this.maxprogress = (int)((double)(AudioGraphView.this.compositeHeight / 50) * 1.2);
            this.monitor.beginTask("Export Image:" + file.getAbsolutePath(), this.maxprogress);
        }

        public void run() {
            this.doExportImage(this.shell, this.file);
            this.shell.getDisplay().asyncExec((Runnable)new MonitorDone());
        }

        public void doExportImage(Shell shell, File file) {
            if (AudioGraphView.this.spectrogramImageFigure.getSpectrogramImage() != null) {
                BufferedImage bufferedImage = new BufferedImage((int)((double)((AudioGraphView)AudioGraphView.this).spectrogramImageFigure.getSpectrogramImage().getBounds().width * AudioGraphView.this.defaultZoom.getZoom() + (double)AudioGraphView.this.graphLeft), AudioGraphView.this.compositeHeight + AudioGraphView.this.graphTop, 2);
                java.awt.Graphics g = bufferedImage.getGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, AudioGraphView.this.graphLeft, AudioGraphView.this.graphTop);
                Image spectrogram = new Image((Device)shell.getDisplay(), (int)((double)((AudioGraphView)AudioGraphView.this).spectrogramImageFigure.getSpectrogramImage().getBounds().width * AudioGraphView.this.defaultZoom.getZoom()), AudioGraphView.this.compositeHeight);
                SWTGraphics graphics = new SWTGraphics(new GC((Drawable)spectrogram));
                AudioGraphView.this.spectrogramImageFigure.paint((Graphics)graphics);
                BufferedImagePainter painter = new BufferedImagePainter();
                painter.setMonitor((ProgressMonitor)this);
                painter.drawAtBufferedImage(bufferedImage, spectrogram, AudioGraphView.this.graphLeft, AudioGraphView.this.graphTop);
                spectrogram.dispose();
                graphics.dispose();
                Image verticalImage = new Image((Device)shell.getDisplay(), AudioGraphView.this.graphLeft, AudioGraphView.this.compositeHeight);
                GC verticalGC = new GC((Drawable)verticalImage);
                AudioGraphView.this.imageMemoryComposite.getVerticalGraphPainter().draw(verticalGC, AudioGraphView.this.graphLeft - 1, AudioGraphView.this.compositeHeight, AudioGraphView.this.compositeHeight);
                painter.drawAtBufferedImage(bufferedImage, verticalImage, 0, AudioGraphView.this.graphTop);
                verticalImage.dispose();
                verticalGC.dispose();
                Image horizontalImage = new Image((Device)shell.getDisplay(), (int)((double)((AudioGraphView)AudioGraphView.this).spectrogramImageFigure.getSpectrogramImage().getBounds().width * AudioGraphView.this.defaultZoom.getZoom()), AudioGraphView.this.graphTop);
                GC horizontalGC = new GC((Drawable)horizontalImage);
                AudioGraphView.this.imageMemoryComposite.getHorizontalGraphPainter().draw(horizontalGC, 0, AudioGraphView.this.graphTop - 1, (int)((double)((AudioGraphView)AudioGraphView.this).spectrogramImageFigure.getSpectrogramImage().getBounds().width * AudioGraphView.this.defaultZoom.getZoom()));
                painter.drawAtBufferedImage(bufferedImage, horizontalImage, AudioGraphView.this.graphLeft, 0);
                horizontalImage.dispose();
                horizontalGC.dispose();
                try {
                    ImageIO.write((RenderedImage)bufferedImage, "png", file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                bufferedImage = null;
                System.gc();
            }
        }

        public void worked(int arg0) {
            this.shell.getDisplay().asyncExec((Runnable)new MonitorWork());
        }

        public boolean isCanceled() {
            return this.monitor.isCanceled();
        }

        public class MonitorDone
        extends Thread {
            public void run() {
                ExportImage.this.monitor.done();
            }
        }

        public class MonitorWork
        extends Thread {
            public void run() {
                ExportImage.this.monitor.worked(1);
            }
        }
    }

    public class SetAudioData
    extends Thread {
        Formant[] formants;
        Image spectrogramImage;
        Spectrogram spectrogram;

        public SetAudioData(Spectrogram spectrogram, Image spectrogramImage, Formant[] formants) {
            this.spectrogram = spectrogram;
            this.spectrogramImage = spectrogramImage;
            this.formants = formants;
        }

        public void run() {
            AudioGraphView.this.setAudioData(this.spectrogram, this.spectrogramImage, this.formants);
        }
    }

    public class OpenSpectrogram
    implements IRunnableWithProgress,
    ProgressMonitor {
        File file;
        Shell shell;
        IProgressMonitor monitor;

        public OpenSpectrogram(Shell shell, File file) {
            this.file = file;
            this.shell = shell;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.monitor = monitor;
            int ms = 200;
            int step = 0;
            try {
                AudioInputStream input = AudioSystem.getAudioInputStream(this.file);
                AudioFormat format = input.getFormat();
                AudioGraphView.this.samplerate = (int)format.getSampleRate();
                step = (int)(input.getFrameLength() / (long)(AudioGraphView.this.samplerate / ms));
                log.trace((Object)("framesize:" + input.getFrameLength() + ",samplerate=" + AudioGraphView.this.samplerate + " ms=" + ms));
            }
            catch (UnsupportedAudioFileException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            int persample = AudioGraphView.this.samplerate / ms;
            monitor.beginTask("Open File " + this.file.getAbsolutePath(), step * 2);
            try {
                if (AudioGraphView.this.spectrogramImageFigure.getSpectrogramImage() != null && !AudioGraphView.this.spectrogramImageFigure.getSpectrogramImage().isDisposed()) {
                    AudioGraphView.this.spectrogramImageFigure.getSpectrogramImage().dispose();
                }
                if (AudioGraphView.this.fit) {
                    AudioGraphView.this.khzMemoryPainter.setSamplerate(AudioGraphView.this.samplerate);
                }
                Spectrogram spectrogram = AudioGraphView.this.snackExecuter.getSpectram(this.file.getAbsolutePath(), AudioGraphView.this.samplerate, 512, persample, 0, 0, this);
                if (monitor.isCanceled()) {
                    return;
                }
                Formant[] formants = AudioGraphView.this.snackExecuter.getFormants(this.file.getAbsolutePath());
                AudioGraphView.this.painter.setMonitor(this);
                Image baseSpectrogramImage = AudioGraphView.this.painter.createImage(spectrogram);
                if (monitor.isCanceled()) {
                    return;
                }
                monitor.done();
                if (spectrogram != null && baseSpectrogramImage != null && formants != null) {
                    this.shell.getDisplay().syncExec((Runnable)new SetAudioData(spectrogram, baseSpectrogramImage, formants));
                } else {
                    log.debug((Object)"SetAudioData:something null");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void worked(int v) {
            this.monitor.worked(v);
        }

        public boolean isCanceled() {
            return this.monitor.isCanceled();
        }
    }
}

