/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.FeatureContentProvider;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISiteContentProvider;
import org.eclipse.update.core.IVerifier;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class FeatureExecutableContentProvider
extends FeatureContentProvider {
    public FeatureExecutableContentProvider(URL url) {
        super(url);
    }

    private String getPath(IPluginEntry pluginEntry) throws IOException, CoreException {
        File pluginPath;
        ISiteContentProvider provider = this.getFeature().getSite().getSiteContentProvider();
        URL fileURL = provider.getArchiveReference(this.getPathID(pluginEntry));
        String result = fileURL.getFile();
        if (!result.endsWith(".jar") && !result.endsWith(File.separator)) {
            result = String.valueOf(result) + File.separator;
        }
        if (!(pluginPath = new File(result)).exists()) {
            throw new IOException(Policy.bind("FeatureExecutableContentProvider.FileDoesNotExist", result));
        }
        return result;
    }

    private String getFeaturePath() throws IOException {
        File pluginDir;
        String result = this.getFeature().getURL().getFile();
        if (!result.endsWith(File.separator) && !result.endsWith("/")) {
            result = String.valueOf(result) + File.separator;
        }
        if (!(pluginDir = new File(result)).exists()) {
            throw new IOException(Policy.bind("FeatureExecutableContentProvider.FileDoesNotExist", result));
        }
        return result;
    }

    private List getFiles(File dir) throws IOException {
        ArrayList<File> result = new ArrayList<File>();
        if (!dir.isDirectory()) {
            String msg = Policy.bind("FeatureExecutableContentProvider.InvalidDirectory", dir.getAbsolutePath());
            throw new IOException(msg);
        }
        File[] files = dir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    result.addAll(this.getFiles(files[i]));
                } else {
                    result.add(files[i]);
                }
                ++i;
            }
        }
        return result;
    }

    public IVerifier getVerifier() throws CoreException {
        return null;
    }

    public ContentReference getFeatureManifestReference(InstallMonitor monitor) throws CoreException {
        ContentReference result = null;
        try {
            result = new ContentReference("feature.xml", new URL(this.getURL(), "feature.xml"));
        }
        catch (MalformedURLException e) {
            throw Utilities.newCoreException(Policy.bind("FeatureExecutableContentProvider.UnableToCreateURLFor", String.valueOf(this.getURL().toExternalForm()) + " " + "feature.xml"), e);
        }
        return result;
    }

    public ContentReference[] getArchiveReferences(InstallMonitor monitor) throws CoreException {
        return new ContentReference[0];
    }

    public ContentReference[] getPluginEntryArchiveReferences(IPluginEntry pluginEntry, InstallMonitor monitor) throws CoreException {
        ContentReference[] result = new ContentReference[1];
        String archiveID = this.getPathID(pluginEntry);
        try {
            File archiveFile = new File(this.getPath(pluginEntry));
            result[0] = !archiveFile.isDirectory() && archiveFile.getName().endsWith(".jar") ? new JarContentReference(archiveID, archiveFile) : new ContentReference(archiveID, archiveFile);
        }
        catch (IOException e) {
            throw Utilities.newCoreException(Policy.bind("FeatureExecutableContentProvider.UnableToRetrievePluginEntry", pluginEntry.getVersionedIdentifier().toString()), e);
        }
        return result;
    }

    public ContentReference[] getNonPluginEntryArchiveReferences(INonPluginEntry nonPluginEntry, InstallMonitor monitor) throws CoreException {
        ContentReference[] result = new ContentReference[1];
        ISiteContentProvider provider = this.getFeature().getSite().getSiteContentProvider();
        URL fileURL = provider.getArchiveReference(this.getPathID(nonPluginEntry));
        String fileString = fileURL.getFile();
        File nonPluginData = new File(fileString);
        if (!nonPluginData.exists()) {
            throw Utilities.newCoreException(Policy.bind("FeatureExecutableContentProvider.FileDoesNotExist", fileString), null);
        }
        try {
            result[0] = new ContentReference(nonPluginEntry.getIdentifier(), nonPluginData.toURL());
        }
        catch (MalformedURLException e) {
            throw Utilities.newCoreException(Policy.bind("FeatureExecutableContentProvider.UnableToRetrieveNonPluginEntry", nonPluginEntry.getIdentifier().toString()), e);
        }
        return result;
    }

    public ContentReference[] getFeatureEntryArchiveReferences(InstallMonitor monitor) throws CoreException {
        ContentReference[] contentReferences = new ContentReference[]{new ContentReference(null, this.getURL())};
        return contentReferences;
    }

    public ContentReference[] getFeatureEntryContentReferences(InstallMonitor monitor) throws CoreException {
        ContentReference[] result = new ContentReference[]{};
        try {
            File featureDir = new File(this.getFeaturePath());
            List files = this.getFiles(featureDir);
            result = new ContentReference[files.size()];
            int i = 0;
            while (i < result.length) {
                File currentFile = (File)files.get(i);
                result[i] = new ContentReference(currentFile.getName(), currentFile.toURL());
                ++i;
            }
        }
        catch (IOException e) {
            throw Utilities.newCoreException(Policy.bind("FeatureExecutableContentProvider.UnableToRetrieveFeatureEntryContentRef", this.getFeature().getVersionedIdentifier().toString()), e);
        }
        return result;
    }

    public ContentReference[] getPluginEntryContentReferences(IPluginEntry pluginEntry, InstallMonitor monitor) throws CoreException {
        ContentReference[] references = this.getPluginEntryArchiveReferences(pluginEntry, monitor);
        ContentReference[] result = new ContentReference[]{};
        try {
            if (references[0] instanceof JarContentReference) {
                result = ((JarContentReference)references[0]).peek(null, monitor);
            } else {
                File pluginDir = new File(this.getPath(pluginEntry));
                URL pluginURL = pluginDir.toURL();
                List files = this.getFiles(pluginDir);
                result = new ContentReference[files.size()];
                int i = 0;
                while (i < result.length) {
                    File currentFile = (File)files.get(i);
                    String relativeString = UpdateManagerUtils.getURLAsString(pluginURL, currentFile.toURL());
                    result[i] = new ContentReference(relativeString, currentFile.toURL());
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw Utilities.newCoreException(String.valueOf(Policy.bind("FeatureExecutableContentProvider.UnableToRetriveArchiveContentRef")) + pluginEntry.getVersionedIdentifier().toString(), e);
        }
        this.validatePermissions(result);
        return result;
    }
}

