/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.audiotools.spectrogram;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.jpn.xucker.rcp.audiotools.spectrogram.SpectrogramDrawInfo;
import org.jpn.xucker.rcp.audiotools.spectrogram.SpectrogramFigure;
import org.jpn.xucker.rcp.draw2d.CachedImageLoader;
import org.jpn.xucker.rcp.draw2d.FileImageCache;
import org.jpn.xucker.rcp.draw2d.ScalableImageFigure;

public class SpectrogramListFigure
extends Figure
implements SpectrogramDrawInfo {
    public static Log log;
    private int samplerate = 48000;
    public static final int MAX_SAMPLERATE = 48000;
    private int baseHeight = 512;
    private boolean fit;
    private double vzoom = 1.0;
    private double wzoom = 1.0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.rcp.audiotools.spectrogram.SpectrogramListFigure");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public SpectrogramListFigure() {
        FlowLayout layout = new FlowLayout(true);
        layout.setMajorSpacing(0);
        layout.setMinorSpacing(0);
        this.setLayoutManager((LayoutManager)layout);
        this.setSize(1024, 512);
    }

    public int getBaseHeight() {
        return this.baseHeight;
    }

    public void setBaseHeight(int baseHeight) {
        this.baseHeight = baseHeight;
    }

    public boolean isFit() {
        return this.fit;
    }

    public void setFit(boolean fit) {
        this.fit = fit;
    }

    public int getSampleRate() {
        return this.samplerate;
    }

    public void setSampleRate(int samplerate) {
        this.samplerate = samplerate;
    }

    public double getVzoom() {
        return this.vzoom;
    }

    public void setVzoom(double vzoom) {
        this.vzoom = vzoom;
    }

    public double getWzoom() {
        return this.wzoom;
    }

    public void setWzoom(double wzoom) {
        this.wzoom = wzoom;
        IFigure[] figures = this.getChildren().toArray(new IFigure[this.getChildren().size()]);
        int i = 0;
        while (i < figures.length) {
            if (figures[i] instanceof ScalableImageFigure) {
                ((ScalableImageFigure)figures[i]).setScale(wzoom, this.vzoom);
            }
            ++i;
        }
        this.revalidate();
    }

    public void setZoom(double w, double v) {
        this.setVzoom(v);
        this.setWzoom(w);
    }

    public void paintFigure(Graphics g) {
        log.trace((Object)("paintFigure:" + this.getClientArea()));
    }

    public void init(int imageWidth, int compositeHeight, int pixelSize, FileImageCache imageCache, File baseFolder) {
        this.removeAll();
        this.baseHeight = compositeHeight;
        int figureSize = pixelSize / imageWidth;
        log.trace((Object)("pixelSize = " + pixelSize + ",imageWidth=" + imageWidth));
        if (pixelSize % imageWidth > 0) {
            ++figureSize;
        }
        log.trace((Object)("image-Figure-Size:" + figureSize));
        int i = 0;
        while (i < figureSize) {
            SpectrogramFigure scalableImageFigure = new SpectrogramFigure(this, (CachedImageLoader)imageCache, new File(baseFolder, String.valueOf(this.toLabel(i)) + ".gif").getAbsolutePath(), imageWidth, compositeHeight);
            scalableImageFigure.setScale(this.wzoom, this.vzoom);
            this.add((IFigure)scalableImageFigure);
            ++i;
        }
        this.revalidate();
    }

    public String toLabel(int v) {
        int k = 5;
        String ret = "" + v;
        while (ret.length() < k) {
            ret = "0" + ret;
        }
        return ret;
    }
}

