/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ProjectLocationSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;

public class CopyProjectOperation {
    private MultiStatus errorStatus;
    private Shell parentShell;
    private String newName;
    private boolean canceled;

    public CopyProjectOperation(Shell shell) {
        this.parentShell = shell;
    }

    public void copyProject(IProject project) {
        this.newName = null;
        this.canceled = false;
        this.errorStatus = null;
        ProjectLocationSelectionDialog dialog = new ProjectLocationSelectionDialog(this.parentShell, project);
        dialog.setTitle(IDEWorkbenchMessages.getString("CopyProjectOperation.copyProject"));
        if (dialog.open() != 0) {
            this.canceled = true;
            return;
        }
        Object[] destinationPaths = dialog.getResult();
        if (destinationPaths == null) {
            this.canceled = true;
            return;
        }
        this.newName = (String)destinationPaths[0];
        Path newLocation = new Path((String)destinationPaths[1]);
        boolean completed = this.performProjectCopy(project, this.newName, (IPath)newLocation);
        if (!completed) {
            this.canceled = true;
            return;
        }
        if (this.errorStatus != null) {
            this.canceled = true;
            ErrorDialog.openError((Shell)this.parentShell, (String)IDEWorkbenchMessages.getString("CopyProjectOperation.copyFailedTitle"), null, (IStatus)this.errorStatus);
            this.errorStatus = null;
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public String getNewName() {
        return this.newName;
    }

    private boolean performProjectCopy(final IProject project, final String projectName, final IPath newLocation) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) {
                monitor.beginTask(IDEWorkbenchMessages.getString("CopyProjectOperation.progressTitle"), 100);
                try {
                    try {
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        IProjectDescription newDescription = CopyProjectOperation.this.createProjectDescription(project, projectName, newLocation);
                        monitor.worked(50);
                        project.copy(newDescription, 33, monitor);
                        monitor.worked(50);
                    }
                    catch (CoreException e) {
                        CopyProjectOperation.this.recordError(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                }
                monitor.done();
            }
        };
        try {
            new ProgressMonitorJobsDialog(this.parentShell).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            final String message = e.getTargetException().getMessage();
            this.parentShell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)CopyProjectOperation.this.parentShell, (String)IDEWorkbenchMessages.getString("CopyProjectOperation.copyFailedTitle"), (String)IDEWorkbenchMessages.format("CopyProjectOperation.internalError", new Object[]{message}));
                }
            });
            return false;
        }
        return true;
    }

    private IProjectDescription createProjectDescription(IProject project, String projectName, IPath rootLocation) throws CoreException {
        IProjectDescription newDescription = project.getDescription();
        newDescription.setName(projectName);
        if (rootLocation.equals((Object)Platform.getLocation())) {
            newDescription.setLocation(null);
        } else {
            newDescription.setLocation(rootLocation);
        }
        return newDescription;
    }

    private void recordError(CoreException error) {
        if (this.errorStatus == null) {
            this.errorStatus = new MultiStatus("org.eclipse.ui", 4, IDEWorkbenchMessages.getString("CopyProjectOperation.copyFailedMessage"), (Throwable)error);
        }
        this.errorStatus.merge(error.getStatus());
    }
}

