/*
 * Created on 2005/05/03
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.rcp.audiotools.spectrogram.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.ViewPart;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.rcp.ui.AbstractFileListTable;
import org.jpn.xucker.rcp.ui.FileDirChoicer;

import java.io.File;

/**
 * 
 *
 */
public class MultiSpectrogramView extends ViewPart{
    public static Log log = LogFactory.getLog(MultiSpectrogramView.class);

    public static String ID_VIEW = MultiSpectrogramView.class.getName();
    /* (non-Javadoc)
     * @see org.eclipse.ui.part.WorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    
   private AudioFileListTable listTable = null;

    public void createPartControl(Composite parent) {
       // parent.setLayout(new FillLayout());
        Composite base=new Composite(parent,SWT.NULL);
        base.setLayout(new GridLayout(2,false));
        // TODO Auto-generated method stub
        Button execButton=new Button(base,SWT.NULL);
        execButton.setText("Convert");
        
        GridData data3=new GridData(GridData.FILL_HORIZONTAL);
        data3.heightHint=50;
        execButton.setLayoutData(data3);
        
        
        Group setting=new Group(base,SWT.NULL);
        setting.setText("setting");
        GridData data4=new GridData(GridData.FILL_HORIZONTAL);
        //data4.heightHint=150;
        setting.setLayoutData(data4);
        
       FileDirChoicer choicer=new FileDirChoicer(base,SWT.NULL,FileDirChoicer.DIR,"SAVE",false);
       GridData data=new GridData(GridData.FILL_HORIZONTAL);
       data.horizontalSpan=2;
       choicer.setLayoutData(data);
       
      
       listTable=new AudioFileListTable(base,SWT.NULL);
       
       //table.addFileItem("c:\\tmp\\aiueo.wav");
       
       
       GridData data2=new GridData(GridData.FILL_BOTH);
       data2.horizontalSpan=2;
       listTable.setLayoutData(data2);
       
       
       /*
       FileListImage fileList=new FileListImage(parent,SWT.NULL);
       //fileList.getImageCanvas().set
       fileList.getFileListTable().setFileExtension(new String[]{"wav","ogg"});//TODO change other files.
       GridData data2=new GridData(GridData.FILL_BOTH);
       data2.horizontalSpan=2;
       fileList.setLayoutData(data2);
       */
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.part.WorkbenchPart#setFocus()
     */
    public void setFocus() {
        
    }
    
    
    public static class MultiImageConverter implements Runnable{
        File inputFile[];
        IProgressMonitor monitor;
        
        public MultiImageConverter(File[] inputFile,IProgressMonitor monitor){
            this.inputFile=inputFile;
            this.monitor=monitor;
        }
        
        public void run(){
            
        }
    }
    public static class AudioFileListTable extends AbstractFileListTable{
/**
         * @param arg0
         * @param arg1
         */
        public AudioFileListTable(Composite arg0, int arg1) {
            super(arg0, arg1);
            this.setFileExtension(new String[]{"wav","ogg"});//TODO change automatically get.
            // TODO Auto-generated constructor stub
        }



       
        
       

        /**
         * @param duration
         * @return
         */
        private String toDurationLabel(int duration) {
            // TODO Auto-generated method stub
            return duration+"00:11:24,1000";
        }

        /**
         * @param duration
         * @return
         */
        private int getWidthValue(int duration) {
            // TODO Auto-generated method stub
            return duration*200/1000;
        }

        /**
         * @return
         */
        private int getHeightValue() {
            // TODO Auto-generated method stub
            return 512;
        }

        /**
         * @param file
         * @return
         */
        private int getFileDuration(File file) {
            // TODO Auto-generated method stub
            return 102400;
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.ui.AbstractFileListTable#createHeader()
         */
        public void createHeader() {

            TableColumn tableColumn1 = new TableColumn(this.table, SWT.NONE);
    		TableColumn tableColumn2 = new TableColumn(this.table, SWT.NONE);
    		TableColumn tableColumn3 = new TableColumn(this.table, SWT.NONE);
    		TableColumn tableColumn4 = new TableColumn(this.table, SWT.NONE);
    		TableColumn tableColumn5 = new TableColumn(this.table, SWT.NONE);
    		
    		
    		table.setHeaderVisible(true);
    		table.setLinesVisible(true);
    		tableColumn1.setText("fileName"); //$NON-NLS-1$
    		tableColumn1.setWidth(150);
    		
    		tableColumn2.setText("duration"); //$NON-NLS-1$
    		tableColumn2.setWidth(150);
    		
    		tableColumn3.setText("width"); //$NON-NLS-1$
    		tableColumn3.setWidth(50);
    		
    		tableColumn4.setText("height"); //$NON-NLS-1$
    		tableColumn4.setWidth(50);
    		
    		tableColumn5.setText("directory"); //$NON-NLS-1$
    		tableColumn5.setWidth(150);
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.ui.AbstractFileListTable#addFileItem(java.lang.String)
         */
        public void addFileItem(String path) {
            File file=new File(path);
            
            TableItem item=new TableItem(table,SWT.NULL);
            
            int duration=getFileDuration(file);
            
            String heightValue=""+getHeightValue();
            String widthValue=""+getWidthValue(duration);
            item.setText(new String[]{file.getName(),toDurationLabel(duration),widthValue,heightValue,""+file.getParentFile().getAbsolutePath()});
        
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.ui.AbstractFileListTable#addDirectoryItem(java.lang.String)
         */
        public void addDirectoryItem(String arg0) {
            // TODO Auto-generated method stub
            //ignore this time.
        }
        
    }

}
