/*
 * Created on 2005/04/29
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.snack;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.rcp.audiotools.spectrogram.views.AudioGraphView;


/**
 * 
 *
 */
public class FormantFigure extends Figure{
    public static Log log = LogFactory.getLog(FormantFigure.class);

private double formantFrameMilliSecond=10;//0.01 second default formant.exe executed value.

private final double basePPS=5;//pixel per millisecond.
SmallFormant[] formants;
private int drawHeight=512;

//private int maxHeltz=5501;//fit mode?
private int maxHeltz=48000/2;//TODO  remove.
private int sampleRate;

private double wzoom=1;
private double viewpps=basePPS*wzoom;//pixel per millisecond.


public double getWzoom() {
    return wzoom;
}
public void setWzoom(double wzoom) {
    this.wzoom = wzoom;
    viewpps=basePPS/wzoom;//
    resize();
}
public boolean isFit() {
    return fit;
}
public void setFit(boolean fit) {
    this.fit = fit;
}
public int getSampleRate() {
    return sampleRate;
}
public void setSampleRate(int sampleRate) {
    this.sampleRate = sampleRate;
}
private boolean fit;
public void resize(){
    if(formants!=null){
    setSize((int)(formants.length*(formantFrameMilliSecond/viewpps)),drawHeight);
    log.trace("resize():"+getSize());
    }
    }

private int marginY;
public int getMarginX() {
    return marginX;
}
public void setMarginX(int marginX) {
    this.marginX = marginX;
}
public int getMarginY() {
    return marginY;
}
public void setMarginY(int marginY) {
    this.marginY = marginY;
}
private int marginX;

private int toYLocation(double value){
    if(fit){
       // System.out.println("fit:"+sampleRate);
        //max helz is half of sampleRate.
        return drawHeight-(int)((drawHeight-(marginY*2))*(value/(sampleRate/2)));
        }else{
            return drawHeight-(int)((drawHeight-(marginY*2))*(value/(maxHeltz)));
            
    }
}


private Color[] fColor={new Color(null,255,0,0),new Color(null,0,255,0),new Color(null,0,0,255)};

public void paintFigure(Graphics g) {
    log.trace("paintFigure:"+this.getClientArea());
    //TODO now draw F1 F2 F3
    //add F4 and draw by setting.
    
    //TODO future support.
    double ignorePixel=0;//drawHeight*(1000/basePPS*wzoom)/sampleRate;//spectrogram read something 512 pixel
    
    
    Point preF[]=new Point[3];
    if(formants!=null ){
        log.trace("formantsize:"+formants.length);
   // log.trace("formant-length:"+formants.length);
    
        double resize=formantFrameMilliSecond/viewpps;
        log.trace("resize:"+resize);
        for(int i=0;i<formants.length;i++){
        
        for(int j=0;j<3;j++){
        //System.out.println(""+f1);
        double f;
        if(j==0){
            f=formants[i].getF1();
        }else if(j==1){
            f=formants[i].getF2();
        }else{
            f=formants[i].getF3();
        }
        
        Point currentF=new Point(ignorePixel+marginX*wzoom+(int)(i*resize),marginY+toYLocation(f));
      
        g.setForegroundColor(fColor[j]);
        //g.setBackgroundColor(fColor[j]);
        
        if(i==100 && j==0){
        log.trace(""+i+","+marginX+","+preF[j]+","+currentF);
        }
        
        if(preF[j]!=null){
        g.drawLine(preF[j],currentF);
        }else{
        g.drawLine(currentF,currentF);
        }
        preF[j]=currentF;
        }
        /*
        
        int f2=toCordinate(formants[i].getF2());
        drawY=dy-myy-f2;
        gb.setForeground(f2Color);
        if(x2>myx){
        gb.drawLine(x1,preF2,x2,drawY);
        }
        preF2=drawY;
        
        int f3=toCordinate(formants[i].getF3());
        drawY=dy-myy-f3;
        gb.setForeground(f3Color);
        if(x2>myx){
        gb.drawLine(x1,preF3,x2,drawY);
        }
        preF3=drawY;
        */
    }
    }
}

/**
 * @param formants2
 */
public void setFormants(SmallFormant[] formants) {
    log.trace("setData:"+formants.length);
    this.formants=formants;
    resize();
    //setSize(formants.length*4,512);//TODO change better.
}
}
