/*
 * Created on 2005/04/26
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.rcp.audiotools.spectrogram;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

import org.jpn.xucker.rcp.ui.ProgressMonitor;
import org.jpn.xucker.snack.Spectrogram;

import java.io.File;
import java.io.IOException;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

/**
 * 
 *
 */
public class SpectrogramPainter {
   private Color[] grays=new Color[256]; 
   private Display display;
    
   private ProgressMonitor monitor;
   private int perProgress=100;

   public ProgressMonitor getMonitor() {
    return monitor;
}

public void setMonitor(ProgressMonitor monitor) {
    this.monitor = monitor;
}

   public SpectrogramPainter(Display display){
        this.display=display;
   
    for(int i=0;i<grays.length;i++){
        grays[i]=new Color(null,i,i,i);
    }
    
    }
    
   

        public Image createImage(Spectrogram spectrogram){
        Image bimage=new Image(display,spectrogram.getWidth(),spectrogram.getHeight());
        GC gc=new GC(bimage);
        int[] values=spectrogram.getRawInt();
        int sampleVLength=spectrogram.getHeight();
       // System.out.println(""+sampleVLength+","+values.length+" per="+spectrogram.getHeight()*perProgress);
        for (int i = 0; i < values.length; i++) {
            if(values[i]>0){
            //0 is white.
            gc.setForeground(grays[values[i]]);
            int x=i/sampleVLength;
            int y=sampleVLength-i%sampleVLength;
            gc.drawLine(x,y,x,y);
            /*if(values[i]!=255){
                System.out.println(values[i]+","+grays[values[i]]);
            }*/
            }
            if(monitor!=null && i%(spectrogram.getHeight()*perProgress)==0){
               // System.out.println("perProgress:"+perProgress);
                if(monitor.isCanceled()){
                    gc.dispose();
                    bimage.dispose();
                    return null;
                }
                monitor.worked(perProgress);
            }
        }
        //gc.dispose();
        return bimage;
    }
    
    //TODO move Util class.
    public static int getSampleRate(File file) {
        AudioFormat format=null;
        try {
            format = AudioSystem.getAudioInputStream(file).getFormat();
        } catch (UnsupportedAudioFileException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return (int)format.getSampleRate();
        
    }
    
    //TODO move Util class.
    public static double getDurationSecond(File file) {
        AudioFormat format=null;
        try {
            AudioInputStream input=AudioSystem.getAudioInputStream(file);
            format = input.getFormat();
            return input.getFrameLength()/format.getFrameRate();
        } catch (UnsupportedAudioFileException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return 0;
    }
}
