/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.internal.webapp.data.RequestData;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.WebappWorkingSetManager;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.eclipse.help.internal.workingset.WorkingSet;

public class WorkingSetManagerData
extends RequestData {
    private static final int NONE = 0;
    private static final int ADD = 1;
    private static final int REMOVE = 2;
    private static final int EDIT = 3;
    private String name;
    private WebappWorkingSetManager wsmgr;
    private boolean saved = true;

    public WorkingSetManagerData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        this.wsmgr = new WebappWorkingSetManager(request, response, this.getLocale());
        this.name = request.getParameter("workingSet");
        try {
            switch (this.getOperation()) {
                case 1: {
                    this.addWorkingSet();
                    break;
                }
                case 2: {
                    this.removeWorkingSet();
                    break;
                }
                case 3: {
                    this.editWorkingSet();
                    break;
                }
            }
        }
        catch (IOException iOException) {
            this.saved = false;
        }
    }

    public void addWorkingSet() throws IOException {
        if (this.name != null && this.name.length() > 0) {
            String[] hrefs = this.request.getParameterValues("hrefs");
            if (hrefs == null) {
                hrefs = new String[]{};
            }
            ArrayList<AdaptableHelpResource> selectedElements = new ArrayList<AdaptableHelpResource>(hrefs.length);
            int i = 0;
            while (i < hrefs.length) {
                AdaptableHelpResource res = this.getAdaptableHelpResource(hrefs[i]);
                if (res != null) {
                    selectedElements.add(res);
                }
                ++i;
            }
            AdaptableHelpResource[] elements = new AdaptableHelpResource[selectedElements.size()];
            selectedElements.toArray(elements);
            WorkingSet ws = this.wsmgr.createWorkingSet(this.name, elements);
            this.wsmgr.addWorkingSet(ws);
        }
    }

    public void removeWorkingSet() {
        WorkingSet ws;
        if (this.name != null && this.name.length() > 0 && (ws = this.wsmgr.getWorkingSet(this.name)) != null) {
            this.wsmgr.removeWorkingSet(ws);
        }
    }

    public void editWorkingSet() throws IOException {
        if (this.name != null && this.name.length() > 0) {
            WorkingSet ws;
            String oldName = this.request.getParameter("oldName");
            if (oldName == null || oldName.length() == 0) {
                oldName = this.name;
            }
            if ((ws = this.wsmgr.getWorkingSet(oldName)) != null) {
                String[] hrefs = this.request.getParameterValues("hrefs");
                if (hrefs == null) {
                    hrefs = new String[]{};
                }
                ArrayList<AdaptableHelpResource> selectedElements = new ArrayList<AdaptableHelpResource>(hrefs.length);
                int i = 0;
                while (i < hrefs.length) {
                    AdaptableHelpResource res = this.getAdaptableHelpResource(hrefs[i]);
                    if (res != null) {
                        selectedElements.add(res);
                    }
                    ++i;
                }
                AdaptableHelpResource[] elements = new AdaptableHelpResource[selectedElements.size()];
                selectedElements.toArray(elements);
                ws.setElements(elements);
                ws.setName(this.name);
                this.wsmgr.workingSetChanged(ws);
            }
        }
    }

    public String[] getWorkingSets() {
        WorkingSet[] workingSets = this.wsmgr.getWorkingSets();
        String[] sets = new String[workingSets.length];
        int i = 0;
        while (i < workingSets.length) {
            sets[i] = workingSets[i].getName();
            ++i;
        }
        return sets;
    }

    public String getWorkingSetName() {
        if (this.name == null || this.name.length() == 0) {
            this.name = this.wsmgr.getCurrentWorkingSet();
            if (this.name == null || this.name.length() == 0 || this.wsmgr.getWorkingSet(this.name) == null) {
                this.name = ServletResources.getString("All", this.request);
            }
        }
        return this.name;
    }

    public WorkingSet getWorkingSet() {
        if (this.name != null && this.name.length() > 0) {
            return this.wsmgr.getWorkingSet(this.name);
        }
        return null;
    }

    public boolean isCurrentWorkingSet(int i) {
        WorkingSet[] workingSets = this.wsmgr.getWorkingSets();
        return workingSets[i].getName().equals(this.name);
    }

    private int getOperation() {
        String op = this.request.getParameter("operation");
        if ("add".equals(op)) {
            return 1;
        }
        if ("remove".equals(op)) {
            return 2;
        }
        if ("edit".equals(op)) {
            return 3;
        }
        return 0;
    }

    private AdaptableHelpResource getAdaptableHelpResource(String internalId) {
        AdaptableToc res = this.wsmgr.getAdaptableToc(internalId);
        if (res == null) {
            res = this.wsmgr.getAdaptableTopic(internalId);
        }
        return res;
    }

    public String getSaveError() {
        if (this.saved) {
            return null;
        }
        return UrlUtil.JavaScriptEncode(ServletResources.getString("cookieSaveFailed", this.request));
    }
}

