/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.commons.swt.ui;

import java.io.File;
import java.util.List;
import java.util.Vector;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jpn.xucker.commons.swt.ui.FileStatusChangeEvent;
import org.jpn.xucker.commons.swt.ui.FileStatusChangeListener;
import org.jpn.xucker.commons.util.Messages;
import org.jpn.xucker.commons.util.WildCard;

public class FileListComposite
extends Composite
implements KeyListener,
MouseListener,
SelectionListener {
    private Menu menu1;
    private MenuItem addfile;
    private MenuItem addfolder;
    private MenuItem separatemenu3;
    private MenuItem deletefile;
    private MenuItem deleteAll;
    private Table table;
    private Image fileIcon;
    private Image folderIcon;
    private boolean addsameFile;
    Text filterExtensionsText;
    private boolean visibleFilterExtensions = true;
    private boolean editableExtensions = true;
    GridData gridData_filterExtensionsLabel;
    GridData gridData_filterExtensionsText;
    private String[] filterExtensions;
    private List fileListChangeListener = new Vector();
    private DropTargetListener monitor = new DropMonitor();
    private Label filterExtensionsLabel;
    static /* synthetic */ Class class$0;

    public void setVisibleFilterExtensions(boolean bool) {
        this.filterExtensionsLabel.setVisible(bool);
        this.filterExtensionsText.setVisible(bool);
        this.visibleFilterExtensions = bool;
        if (bool) {
            this.gridData_filterExtensionsLabel.verticalSpan = 1;
            this.gridData_filterExtensionsText.verticalSpan = 1;
        } else {
            this.gridData_filterExtensionsLabel.verticalSpan = 0;
            this.gridData_filterExtensionsText.verticalSpan = 0;
        }
        this.layout();
    }

    public boolean isVisibleFilterExtensions() {
        return this.visibleFilterExtensions;
    }

    public String getFilterExtensionsText() {
        return this.filterExtensionsText.getText();
    }

    public void setFilterExtensionsText(String text) {
        this.filterExtensionsText.setText(text);
    }

    public FileListComposite(Composite parent, int layout) {
        super(parent, layout);
        GridLayout gridLayout = new GridLayout(2, true);
        this.setLayout((Layout)gridLayout);
        this.filterExtensionsLabel = new Label((Composite)this, 0);
        this.gridData_filterExtensionsLabel = new GridData(768);
        this.filterExtensionsLabel.setLayoutData((Object)this.gridData_filterExtensionsLabel);
        this.filterExtensionsLabel.setText("FileterExtensions");
        this.filterExtensionsText = new Text((Composite)this, 0);
        this.gridData_filterExtensionsText = new GridData(768);
        this.filterExtensionsText.setLayoutData((Object)this.gridData_filterExtensionsText);
        Display display = Display.getCurrent();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.commons.swt.ui.FileListComposite");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fileIcon = new Image((Device)display, clazz.getClassLoader().getResourceAsStream("org/jpn/xucker/commons/resource/file.png"));
        Display display2 = Display.getCurrent();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.jpn.xucker.commons.swt.ui.FileListComposite");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.folderIcon = new Image((Device)display2, clazz2.getClassLoader().getResourceAsStream("org/jpn/xucker/commons/resource/folder.png"));
        this.table = new Table((Composite)this, layout);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.table.setLayoutData((Object)data);
        this.table.addMouseListener((MouseListener)this);
        this.table.addKeyListener((KeyListener)this);
        this.menu1 = new Menu((Control)this.table);
        this.table.setMenu(this.menu1);
        this.addfile = new MenuItem(this.menu1, 8);
        this.addfile.setText(Messages.getString("FileListTable.addfile"));
        this.addfile.addSelectionListener((SelectionListener)this);
        this.addfolder = new MenuItem(this.menu1, 8);
        this.addfolder.setText(Messages.getString("FileListTable.adddir"));
        this.addfolder.addSelectionListener((SelectionListener)this);
        this.separatemenu3 = new MenuItem(this.menu1, 2);
        this.deletefile = new MenuItem(this.menu1, 8);
        this.deletefile.setText(Messages.getString("FileListTable.delete_selection"));
        this.deletefile.addSelectionListener((SelectionListener)this);
        MenuItem item = new MenuItem(this.menu1, 2);
        item.setText("");
        this.deleteAll = new MenuItem(this.menu1, 8);
        this.deleteAll.setText(Messages.getString("FileListTable.deleteall"));
        this.deleteAll.addSelectionListener((SelectionListener)this);
        Transfer[] types = new Transfer[]{FileTransfer.getInstance()};
        int operations = 3;
        DropTarget target2 = new DropTarget((Control)this.table, operations);
        target2.setTransfer(types);
        target2.addDropListener((DropTargetListener)new DropMonitor());
    }

    public void widgetSelected(SelectionEvent event) {
        Object target = event.getSource();
        if (target == this.menu1) {
            this.do_menu1();
        } else if (target == this.addfile) {
            this.execAddFile();
        } else if (target == this.addfolder) {
            this.execAddFolder();
        } else if (target == this.deletefile) {
            this.execDeleteFile();
        } else if (target == this.deleteAll) {
            this.execDeleteAll();
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void do_menu1() {
        System.out.println("menu1");
    }

    public String[] toFileterExtensions() {
        if (this.filterExtensionsText.getText().length() > 0) {
            String[] lines = this.filterExtensionsText.getText().split(" ");
            return lines;
        }
        return this.filterExtensions;
    }

    public static String[] converExtensionsToFilterExtensions(String[] extension) {
        if (extension == null) {
            return null;
        }
        String[] filter = new String[extension.length];
        int i = 0;
        while (i < filter.length) {
            filter[i] = "*." + extension[i];
            ++i;
        }
        return filter;
    }

    public void execAddFile() {
        String file;
        FileDialog dialog = new FileDialog(this.table.getShell(), 4096);
        String[] fileter = this.toFileterExtensions();
        if (fileter != null) {
            dialog.setFilterExtensions(fileter);
        }
        if ((file = dialog.open()) != null) {
            this.addFilePath(file);
        }
    }

    public void execAddFolder() {
        DirectoryDialog dialog = new DirectoryDialog(this.table.getShell(), 4096);
        String file = dialog.open();
        if (file != null) {
            this.addDirectoryPath(file);
        }
    }

    public void execDeleteFile() {
        int selection = this.table.getSelectionIndex();
        if (selection != -1) {
            String path = this.table.getItem(selection).getText();
            this.table.remove(selection);
            this.fireRemoveFile(path);
        }
    }

    public void execDeleteAll() {
        int size = this.table.getItemCount();
        int i = size - 1;
        while (i >= 0) {
            String path = this.table.getItem(i).getText();
            this.table.remove(i);
            this.fireRemoveFile(path);
            --i;
        }
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setFileListText(String text) {
        if (text != null && text.length() > 0) {
            String[] path = text.split(";");
            int i = 0;
            while (i < path.length) {
                this.addDragAndDropFile(path[i]);
                ++i;
            }
        }
    }

    public String[] getFiles() {
        String[] result = new String[this.table.getItemCount()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.table.getItem(i).getText();
            ++i;
        }
        return result;
    }

    public int getFileCount() {
        return this.table.getItemCount();
    }

    public String getFileListText() {
        String[] fileList = this.getFiles();
        String result = "";
        int i = 0;
        while (i < fileList.length) {
            result = String.valueOf(result) + fileList[i];
            if (i != fileList.length - 1) {
                result = String.valueOf(result) + ";";
            }
            ++i;
        }
        return result;
    }

    public WildCard[] getWildCards() {
        String[] filter = this.toFileterExtensions();
        if (filter != null) {
            return this.toWildCard(filter);
        }
        return null;
    }

    public boolean acceptFilePattern(String path) {
        String[] filter = this.toFileterExtensions();
        File f = new File(path);
        if (f.isDirectory()) {
            return true;
        }
        if (filter != null) {
            WildCard[] wildCard = this.toWildCard(filter);
            int i = 0;
            while (i < wildCard.length) {
                if (wildCard[i].match(f.getName()) && (this.addsameFile || !this.existPath(path))) {
                    TableItem item = new TableItem(this.table, 0);
                    item.setText(path);
                    item.setImage(this.fileIcon);
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    protected void addFilePath(String path) {
        String[] filter = this.toFileterExtensions();
        if (filter != null) {
            WildCard[] wildCard = this.toWildCard(filter);
            int i = 0;
            while (i < wildCard.length) {
                File f = new File(path);
                if (wildCard[i].match(f.getName()) && (this.addsameFile || !this.existPath(path))) {
                    TableItem item = new TableItem(this.table, 0);
                    item.setText(path);
                    item.setImage(this.fileIcon);
                    break;
                }
                ++i;
            }
        } else if (this.addsameFile || !this.existPath(path)) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(path);
            item.setImage(this.fileIcon);
        }
        this.fireAddFile(path);
    }

    public boolean existPath(String path) {
        int size = this.table.getItemCount();
        int i = 0;
        while (i < size) {
            if (this.table.getItem(i).getText().equals(path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private WildCard[] toWildCard(String[] filters) {
        if (filters == null) {
            return null;
        }
        WildCard[] wildCard = new WildCard[filters.length];
        int i = 0;
        while (i < wildCard.length) {
            wildCard[i] = new WildCard(filters[i]);
            ++i;
        }
        return wildCard;
    }

    protected void addDirectoryPath(String path) {
        TableItem item = new TableItem(this.table, 0);
        item.setText(path);
        item.setImage(this.folderIcon);
        this.fireAddFile(path);
    }

    public void mouseDoubleClick(MouseEvent arg0) {
    }

    public void mouseDown(MouseEvent event) {
        TableItem item;
        if (event.button == 1 && (item = this.table.getItem(new Point(event.x, event.y))) == null) {
            this.table.setSelection(-1);
        }
        if (event.button == 3) {
            if (this.table.getSelectionIndex() == -1) {
                this.deletefile.setEnabled(false);
            } else {
                this.deletefile.setEnabled(true);
            }
        }
    }

    public void mouseUp(MouseEvent arg0) {
    }

    public void keyPressed(KeyEvent arg0) {
    }

    public void keyReleased(KeyEvent event) {
        if (event.keyCode == 127) {
            this.execDeleteFile();
        }
    }

    public synchronized void removeFileListChangeListener(FileStatusChangeListener listener) {
        this.fileListChangeListener.remove(listener);
    }

    public synchronized void addFileListChangeListener(FileStatusChangeListener listener) {
        this.fileListChangeListener.add(listener);
    }

    public void fireRemoveFile(String file) {
        FileStatusChangeEvent event = new FileStatusChangeEvent((Object)this, file);
        FileListComposite fileListComposite = this;
        synchronized (fileListComposite) {
            FileStatusChangeListener[] listeners = this.fileListChangeListener.toArray(new FileStatusChangeListener[this.fileListChangeListener.size()]);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].removeList(event);
                ++i;
            }
        }
    }

    public void fireAddFile(String file) {
        FileStatusChangeEvent event = new FileStatusChangeEvent((Object)this, file);
        FileListComposite fileListComposite = this;
        synchronized (fileListComposite) {
            FileStatusChangeListener[] listeners = this.fileListChangeListener.toArray(new FileStatusChangeListener[this.fileListChangeListener.size()]);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].addList(event);
                ++i;
            }
        }
    }

    public void addDragAndDropFile(String path) {
        File file = new File(path);
        if (file.isDirectory()) {
            this.addDirectoryPath(path);
        } else {
            this.addFilePath(path);
        }
    }

    public DropTargetListener getDropTargetMonitor() {
        return this.monitor;
    }

    public boolean isEditableExtensions() {
        return this.editableExtensions;
    }

    public void setEditableExtensions(boolean editableExtensions) {
        this.editableExtensions = editableExtensions;
        this.filterExtensionsText.setEditable(editableExtensions);
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions = filterExtensions;
    }

    public class DropMonitor
    extends DropTargetAdapter {
        public void dragEnter(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            String[] files = (String[])event.data;
            int i = 0;
            while (i < files.length) {
                FileListComposite.this.addDragAndDropFile(files[i]);
                ++i;
            }
        }
    }
}

