/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.commons.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import org.jpn.xucker.commons.util.ApplicationProperties;
import org.jpn.xucker.commons.util.FileNotFoundAction;

public class FileProperties
implements ApplicationProperties {
    Properties properties;
    private File file;
    private FileNotFoundAction action;
    private boolean changed;

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public FileProperties(File file) {
        this(file, null);
    }

    public FileProperties(File file, FileNotFoundAction action) {
        this.file = file;
        this.action = action;
        this.properties = new Properties();
    }

    public void load() {
        try {
            if (this.file.exists()) {
                this.properties.load(new FileInputStream(this.file));
            } else if (this.action != null) {
                this.action.exec(this.file, "");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void set(String key, int value) {
        if (this.get(key) == null) {
            this.changed = true;
        } else if (this.getInt(key, -1) != value) {
            this.changed = true;
        }
        this.set(key, "" + value);
    }

    public int getInt(String key, int defaultValue) {
        int v = defaultValue;
        String s = this.get(key);
        if (s != null) {
            try {
                v = Integer.parseInt(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return v;
    }

    public void remove(String key) {
        ((Hashtable)this.properties).remove(key);
    }

    public void set(String key, String value) {
        if (value == null) {
            throw new RuntimeException("value is null");
        }
        String old = (String)((Hashtable)this.properties).get(key);
        if (old == null && value != null) {
            this.changed = true;
        } else if (!old.equals(value)) {
            this.changed = true;
        }
        ((Hashtable)this.properties).put(key, value);
    }

    public String[] getKeys() {
        return ((Hashtable)this.properties).keySet().toArray(new String[((Hashtable)this.properties).size()]);
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public String get(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public void save() {
        try {
            this.properties.store(new FileOutputStream(this.file), null);
            this.changed = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getFilePath() {
        return this.file.getAbsolutePath();
    }

    public boolean getBoolean(String key) {
        String value = this.get(key);
        return value != null && value.equals("true");
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value.equals("true");
    }

    public void setBoolean(String key, boolean selection) {
        if (this.get(key) == null) {
            this.changed = true;
        } else if (this.getBoolean(key) != selection) {
            this.changed = true;
        }
        this.set(key, "" + selection);
    }

    public boolean avaiable() {
        return this.file.exists();
    }
}

