/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.ui;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.jpn.xucker.rcp.ui.Messages;

public class SliderFieldEditor
extends FieldEditor {
    public static Log log;
    private int min;
    private int max;
    private int value;
    private int defaultValue;
    private Label valueLabel;
    private Scale scale;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.rcp.ui.SliderFieldEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public SliderFieldEditor(String name, String labelText, Composite parent, int min, int max, int value) {
        this.init(name, labelText);
        this.min = min;
        this.max = max;
        this.value = this.defaultValue = value;
        this.createControl(parent);
        log.trace((Object)"sliderFieldEditor:init");
    }

    protected void adjustForNumColumns(int numColumns) {
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        log.info((Object)("numcolumns:" + numColumns));
        Label label = new Label(parent, 0);
        label.setText(this.getLabelText());
        Composite base = new Composite(parent, 0);
        GridData data2 = new GridData(768);
        data2.horizontalSpan = numColumns;
        base.setLayoutData((Object)data2);
        base.setLayout((Layout)new GridLayout());
        this.scale = new Scale(base, 256);
        this.scale.setMinimum(this.min);
        this.scale.setMaximum(this.max);
        this.scale.setSelection(this.value);
        GridData data = new GridData(768);
        this.scale.setLayoutData((Object)data);
        Composite labels = new Composite(base, 0);
        labels.setLayoutData((Object)new GridData(768));
        labels.setLayout((Layout)new GridLayout(3, true));
        Label minLabel = new Label(labels, 0x1000000);
        minLabel.setText(String.valueOf(Messages.getString("min")) + this.min);
        minLabel.setLayoutData((Object)new GridData(768));
        this.valueLabel = new Label(labels, 0x1000000);
        this.valueLabel.setText("" + this.value);
        this.valueLabel.setLayoutData((Object)new GridData(768));
        Label maxLabel = new Label(labels, 0x1000000);
        maxLabel.setText(String.valueOf(Messages.getString("max")) + this.max);
        maxLabel.setLayoutData((Object)new GridData(768));
        this.scale.addSelectionListener((SelectionListener)new LabelChange());
    }

    protected void doLoad() {
        log.trace((Object)("doLoad:" + this.getPreferenceStore().getString(this.getPreferenceName())));
        this.updateValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        log.trace((Object)("doLoadDefault:" + this.getPreferenceStore().getDefaultString(this.getPreferenceName())));
        this.updateValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    private void updateValue(String string) {
        if (string.length() == 0) {
            this.scale.setSelection(this.defaultValue);
        } else {
            this.scale.setSelection(Integer.parseInt(string));
        }
        this.scale.redraw();
        this.valueLabel.setText("" + this.scale.getSelection());
    }

    protected void doStore() {
        int oldValue = this.getPreferenceStore().getInt(this.getPreferenceName());
        log.info((Object)("dostore:" + this.scale.getSelection() + "," + oldValue));
        this.getPreferenceStore().setValue(this.getPreferenceName(), "" + this.scale.getSelection());
    }

    public int getNumberOfControls() {
        return 2;
    }

    public class LabelChange
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            SliderFieldEditor.this.valueLabel.setText("" + SliderFieldEditor.this.scale.getSelection());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

