/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.wizards.datatransfer.FileSystemExporter;

class FileSystemExportOperation
implements IRunnableWithProgress {
    private IPath path;
    private IProgressMonitor monitor;
    private FileSystemExporter exporter = new FileSystemExporter();
    private List resourcesToExport;
    private IOverwriteQuery overwriteCallback;
    private IResource resource;
    private List errorTable = new ArrayList(1);
    private static final int OVERWRITE_NOT_SET = 0;
    private static final int OVERWRITE_NONE = 1;
    private static final int OVERWRITE_ALL = 2;
    private int overwriteState = 0;
    private boolean createLeadupStructure = true;
    private boolean createContainerDirectories = true;

    public FileSystemExportOperation(List resources, String destinationPath, IOverwriteQuery overwriteImplementor) {
        Iterator elementsEnum = resources.iterator();
        while (elementsEnum.hasNext()) {
            IResource currentResource = (IResource)elementsEnum.next();
            if (!this.isDescendent(resources, currentResource)) continue;
            elementsEnum.remove();
        }
        this.resourcesToExport = resources;
        this.path = new Path(destinationPath);
        this.overwriteCallback = overwriteImplementor;
    }

    public FileSystemExportOperation(IResource res, String destinationPath, IOverwriteQuery overwriteImplementor) {
        this.resource = res;
        this.path = new Path(destinationPath);
        this.overwriteCallback = overwriteImplementor;
    }

    public FileSystemExportOperation(IResource res, List resources, String destinationPath, IOverwriteQuery overwriteImplementor) {
        this(res, destinationPath, overwriteImplementor);
        this.resourcesToExport = resources;
    }

    protected void addError(String message, Throwable e) {
        this.errorTable.add(new Status(4, "org.eclipse.ui", 0, message, e));
    }

    protected int countChildrenOf(IResource parentResource) throws CoreException {
        if (parentResource.getType() == 1) {
            return 1;
        }
        int count = 0;
        if (parentResource.isAccessible()) {
            IResource[] children = ((IContainer)parentResource).members();
            int i = 0;
            while (i < children.length) {
                count += this.countChildrenOf(children[i]);
                ++i;
            }
        }
        return count;
    }

    protected int countSelectedResources() throws CoreException {
        int result = 0;
        Iterator resources = this.resourcesToExport.iterator();
        while (resources.hasNext()) {
            result += this.countChildrenOf((IResource)resources.next());
        }
        return result;
    }

    protected void createLeadupDirectoriesFor(IResource childResource) {
        IPath resourcePath = childResource.getFullPath().removeLastSegments(1);
        int i = 0;
        while (i < resourcePath.segmentCount()) {
            this.path = this.path.append(resourcePath.segment(i));
            this.exporter.createFolder(this.path);
            ++i;
        }
    }

    protected void exportAllResources() throws InterruptedException {
        if (this.resource.getType() == 1) {
            this.exportFile((IFile)this.resource, this.path);
        } else {
            try {
                this.exportChildren(((IContainer)this.resource).members(), this.path);
            }
            catch (CoreException e) {
                this.errorTable.add(e);
            }
        }
    }

    protected void exportChildren(IResource[] children, IPath currentPath) throws InterruptedException {
        int i = 0;
        while (i < children.length) {
            IResource child = children[i];
            if (child.isAccessible()) {
                if (child.getType() == 1) {
                    this.exportFile((IFile)child, currentPath);
                } else {
                    IPath destination = currentPath.append(child.getName());
                    this.exporter.createFolder(destination);
                    try {
                        this.exportChildren(((IContainer)child).members(), destination);
                    }
                    catch (CoreException e) {
                        this.errorTable.add(e.getStatus());
                    }
                }
            }
            ++i;
        }
    }

    protected void exportFile(IFile file, IPath location) throws InterruptedException {
        IPath fullPath = location.append(file.getName());
        this.monitor.subTask(file.getFullPath().toString());
        String properPathString = fullPath.toOSString();
        File targetFile = new File(properPathString);
        if (targetFile.exists()) {
            if (!targetFile.canWrite()) {
                this.errorTable.add(new Status(4, "org.eclipse.ui", 0, DataTransferMessages.format("DataTransfer.cannotOverwrite", new Object[]{targetFile.getAbsolutePath()}), null));
                this.monitor.worked(1);
                return;
            }
            if (this.overwriteState == 1) {
                return;
            }
            if (this.overwriteState != 2) {
                String overwriteAnswer = this.overwriteCallback.queryOverwrite(properPathString);
                if (overwriteAnswer.equals("CANCEL")) {
                    throw new InterruptedException();
                }
                if (overwriteAnswer.equals("NO")) {
                    this.monitor.worked(1);
                    return;
                }
                if (overwriteAnswer.equals("NOALL")) {
                    this.monitor.worked(1);
                    this.overwriteState = 1;
                    return;
                }
                if (overwriteAnswer.equals("ALL")) {
                    this.overwriteState = 2;
                }
            }
        }
        try {
            this.exporter.write((IResource)file, fullPath);
        }
        catch (IOException e) {
            this.errorTable.add(new Status(4, "org.eclipse.ui", 0, DataTransferMessages.format("DataTransfer.errorExporting", new Object[]{fullPath, e.getMessage()}), (Throwable)e));
        }
        catch (CoreException e) {
            this.errorTable.add(new Status(4, "org.eclipse.ui", 0, DataTransferMessages.format("DataTransfer.errorExporting", new Object[]{fullPath, e.getMessage()}), (Throwable)e));
        }
        this.monitor.worked(1);
        ModalContext.checkCanceled((IProgressMonitor)this.monitor);
    }

    protected void exportSpecifiedResources() throws InterruptedException {
        Iterator resources = this.resourcesToExport.iterator();
        IPath initPath = (IPath)this.path.clone();
        while (resources.hasNext()) {
            IResource currentResource = (IResource)resources.next();
            if (!currentResource.isAccessible()) continue;
            this.path = initPath;
            if (this.resource == null) {
                if (this.createLeadupStructure) {
                    this.createLeadupDirectoriesFor(currentResource);
                }
            } else {
                IPath containersToCreate = currentResource.getFullPath().removeFirstSegments(this.resource.getFullPath().segmentCount()).removeLastSegments(1);
                int i = 0;
                while (i < containersToCreate.segmentCount()) {
                    this.path = this.path.append(containersToCreate.segment(i));
                    this.exporter.createFolder(this.path);
                    ++i;
                }
            }
            if (currentResource.getType() == 1) {
                this.exportFile((IFile)currentResource, this.path);
                continue;
            }
            if (this.createContainerDirectories) {
                this.path = this.path.append(currentResource.getName());
                this.exporter.createFolder(this.path);
            }
            try {
                this.exportChildren(((IContainer)currentResource).members(), this.path);
            }
            catch (CoreException e) {
                this.errorTable.add(e.getStatus());
            }
        }
    }

    public IStatus getStatus() {
        IStatus[] errors = new IStatus[this.errorTable.size()];
        this.errorTable.toArray(errors);
        return new MultiStatus("org.eclipse.ui", 0, errors, DataTransferMessages.getString("FileSystemExportOperation.problemsExporting"), null);
    }

    protected boolean isDescendent(List resources, IResource child) {
        if (child.getType() == 4) {
            return false;
        }
        IContainer parent = child.getParent();
        if (resources.contains(parent)) {
            return true;
        }
        return this.isDescendent(resources, (IResource)parent);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor progressMonitor) throws InterruptedException {
        this.monitor = progressMonitor;
        if (this.resource != null) {
            if (this.createLeadupStructure) {
                this.createLeadupDirectoriesFor(this.resource);
            }
            if (this.createContainerDirectories && this.resource.getType() != 1) {
                this.path = this.path.append(this.resource.getName());
                this.exporter.createFolder(this.path);
            }
        }
        try {
            int totalWork = -1;
            try {
                totalWork = this.resourcesToExport == null ? this.countChildrenOf(this.resource) : this.countSelectedResources();
            }
            catch (CoreException e) {
                this.errorTable.add(e.getStatus());
            }
            this.monitor.beginTask(DataTransferMessages.getString("DataTransfer.exportingTitle"), totalWork);
            if (this.resourcesToExport == null) {
                this.exportAllResources();
            } else {
                this.exportSpecifiedResources();
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.monitor.done();
    }

    public void setCreateContainerDirectories(boolean value) {
        this.createContainerDirectories = value;
    }

    public void setCreateLeadupStructure(boolean value) {
        this.createLeadupStructure = value;
    }

    public void setOverwriteFiles(boolean value) {
        if (value) {
            this.overwriteState = 2;
        }
    }
}

