/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.subplayer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Shell;
import org.jpn.xucker.rcp.draw2d.WrapTextPainter;

public class TextAndImageFigure
extends Figure {
    public static Log log;
    private Image image;
    private String text;
    private Font font;
    private Shell shell;
    private int alpha = 200;
    private boolean imageOnly;
    private boolean reimage;
    private boolean disposeImage;
    private Image bufferImage;
    private ImageData bufferData;
    private GC imageGc;
    private WrapTextPainter wrapTextPainter;
    int marginX = 10;
    int marginY = 10;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.rcp.subplayer.TextAndImageFigure");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.disposeBuffer();
    }

    private void disposeBuffer() {
        log.trace((Object)"call dispose buffer");
        if (this.bufferImage != null) {
            log.trace((Object)"dispose buffer");
            this.bufferImage.dispose();
            this.bufferImage = null;
            this.bufferData = null;
            this.imageGc.dispose();
            this.imageGc = null;
            System.gc();
        }
    }

    public TextAndImageFigure(Shell shell) {
        this.shell = shell;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        if (this.disposeImage && this.image != null) {
            this.image.dispose();
        }
        this.image = image;
        this.reimage = true;
    }

    public void setSize(int x, int y) {
        this.reimage = true;
        super.setSize(x, y);
    }

    public void createImage() {
        if (this.bufferImage != null) {
            this.disposeBuffer();
        }
        log.trace((Object)"textandimage");
        this.bufferData = new ImageData(this.getClientArea().width, this.getClientArea().height, 24, new PaletteData(255, 65280, 0xFF0000));
        this.bufferData.alpha = this.alpha;
        this.bufferImage = new Image((Device)this.shell.getDisplay(), this.bufferData);
        this.imageGc = new GC((Drawable)this.bufferImage);
        this.imageGc.setBackground(this.getBackgroundColor());
        this.imageGc.setForeground(this.getForegroundColor());
        this.imageGc.fillRectangle(0, 0, this.getClientArea().width, this.getClientArea().height);
        if (this.image != null) {
            if (this.image.getBounds().height > this.getClientArea().height) {
                this.imageGc.drawImage(this.image, 0, this.getClientArea().height - this.image.getBounds().height);
            } else {
                this.imageGc.drawImage(this.image, 0, 0);
            }
        }
        if (!this.imageOnly && this.text != null) {
            if (this.font != null) {
                this.imageGc.setFont(this.font);
            }
            this.wrapTextPainter = new WrapTextPainter(this.getClientArea().width - this.marginX * 2, this.font);
            this.wrapTextPainter.setText(this.text);
            this.wrapTextPainter.paint(this.imageGc, this.marginX, this.marginY);
        }
    }

    public void paintFigure(Graphics g) {
        if (this.bufferImage == null || this.reimage) {
            this.createImage();
        }
        g.drawImage(this.bufferImage, this.getClientArea().x, this.getClientArea().y);
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        if (this.bufferData != null) {
            this.bufferData.alpha = alpha;
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.disposeBuffer();
    }

    public boolean isDisposeImage() {
        return this.disposeImage;
    }

    public void setDisposeImage(boolean disposeImage) {
        this.disposeImage = disposeImage;
    }

    public WrapTextPainter getWrapTextPainter() {
        return this.wrapTextPainter;
    }

    public int getMarginX() {
        return this.marginX;
    }

    public void setMarginX(int marginX) {
        this.marginX = marginX;
    }

    public int getMarginY() {
        return this.marginY;
    }

    public void setMarginY(int marginY) {
        this.marginY = marginY;
    }
}

