package org.jpn.xucker.rcp.subplayer.preferences;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import org.jpn.xucker.rcp.subplayer.SubplayerPlugin;
import org.jpn.xucker.rcp.ui.SliderFieldEditor;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */


public class LayerPage
	extends FieldEditorPreferencePage
	implements IWorkbenchPreferencePage {
    public static final String BASE="subplay.layer_";
	public static final String LAYER_X1="subplay.layer_x_1";
	public static final String LAYER_Y1="subplay.layer_y_1";
	public static final String LAYER_W1="subplay.layer_w_1";
	public static final String LAYER_H1="subplay.layer_h_1";
	public static final String LAYER_X2="subplay.layer_x_2";
	public static final String LAYER_Y2="subplay.layer_y_2";
	public static final String LAYER_W2="subplay.layer_w_2";
	public static final String LAYER_H2="subplay.layer_h_2";
	
	public static final String LAYER_X3="subplay.layer_x_3";
	public static final String LAYER_Y3="subplay.layer_y_3";
	public static final String LAYER_W3="subplay.layer_w_3";
	public static final String LAYER_H3="subplay.layer_h_3";
	
	public static final String LAYER_X4="subplay.layer_x_4";
	public static final String LAYER_Y4="subplay.layer_y_4";
	public static final String LAYER_W4="subplay.layer_w_4";
	public static final String LAYER_H4="subplay.layer_h_4";
	public LayerPage() {
		super(GRID);
		setPreferenceStore(SubplayerPlugin.getDefault().getPreferenceStore());
		setDescription("Layer size");
		initializeDefaults();
	}
/**
 * Sets the default values of the preferences.
 */
	private void initializeDefaults() {
		IPreferenceStore store = getPreferenceStore();
		/*
		FontData fontData=new FontData("MS UI Gothic",28,SWT.NONE);
		
		PreferenceConverter.setDefault(getPreferenceStore(),SubViewPage.LAYER1_FONT,fontData);
		
		
		PreferenceConverter.setDefault(getPreferenceStore(),SubViewPage.LAYER1_BGCOLOR,ColorConstants.black.getRGB());
		PreferenceConverter.setDefault(getPreferenceStore(),SubViewPage.LAYER1_FGCOLOR,ColorConstants.white.getRGB());
		*/
		
	}
	
/**
 * Creates the field editors. Field editors are abstractions of
 * the common GUI blocks needed to manipulate various types
 * of preferences. Each field editor knows how to save and
 * restore itself.
 */
	

    protected void createFieldEditors() {
        
    }
	
	public void init(IWorkbench workbench) {
	}
}