package org.jpn.xucker.rcp.subplayer.preferences;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import org.jpn.xucker.rcp.subplayer.SubplayerPlugin;
import org.jpn.xucker.rcp.ui.SliderFieldEditor;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */


public class SubViewPage
	extends FieldEditorPreferencePage
	implements IWorkbenchPreferencePage {
	public static final String LAYER1_TRANSPARENT = "subview.layer1_transparent";
	public static final String LAYER1_BGCOLOR = "subview.layer1_bg_color";
	public static final String LAYER1_FGCOLOR = "subview.layer1_fg_color";
	public static final String LAYER1_FONT = "subview.layer1_font";

	public static final String BGIMAGE = "subview.bgimage";
	public static final int defaultJpegQuality=50;
	public SubViewPage() {
		super(GRID);
		setPreferenceStore(SubplayerPlugin.getDefault().getPreferenceStore());
		setDescription("SubView Setting");
		initializeDefaults();
	}
/**
 * Sets the default values of the preferences.
 */
	private void initializeDefaults() {
		IPreferenceStore store = getPreferenceStore();
		/*
		FontData fontData=new FontData("MS UI Gothic",28,SWT.NONE);
		
		PreferenceConverter.setDefault(getPreferenceStore(),SubViewPage.LAYER1_FONT,fontData);
		
		
		PreferenceConverter.setDefault(getPreferenceStore(),SubViewPage.LAYER1_BGCOLOR,ColorConstants.black.getRGB());
		PreferenceConverter.setDefault(getPreferenceStore(),SubViewPage.LAYER1_FGCOLOR,ColorConstants.white.getRGB());
		*/
		
	}
	
/**
 * Creates the field editors. Field editors are abstractions of
 * the common GUI blocks needed to manipulate various types
 * of preferences. Each field editor knows how to save and
 * restore itself.
 */
	

    protected void createFieldEditors() {
        FieldEditor editor=new SliderFieldEditor(
                LAYER1_TRANSPARENT,
    			"Layer Transparent", //$NON-NLS-1$
    			
    		 getFieldEditorParent(),32,255,64);//default value is ignored.
       addField(editor);
        
        addField(new ColorFieldEditor(LAYER1_FGCOLOR,"Text Color",getFieldEditorParent()));
        addField(new FontFieldEditor(LAYER1_FONT,"Text Font",getFieldEditorParent()));
        
        addField(new ColorFieldEditor(LAYER1_BGCOLOR,"Layer Color",getFieldEditorParent()));
        
        addField(new FileFieldEditor(BGIMAGE,"BackgroundImage",getFieldEditorParent()));
        
        /* 
        addField(new SliderFieldEditor(
                LAYER1_TRANSPARENT,
    			"Layer Transparent", //$NON-NLS-1$
    			
    		 getFieldEditorParent(),32,255,64));
        addField(new SliderFieldEditor(
                LAYER1_TRANSPARENT,
    			"Layer Transparent", //$NON-NLS-1$
    			
    		 getFieldEditorParent(),32,255,64));
        addField(new SliderFieldEditor(
                LAYER1_TRANSPARENT,
    			"Layer Transparent", //$NON-NLS-1$
    			
    		 getFieldEditorParent(),32,255,64));
        addField(new SliderFieldEditor(
                LAYER1_TRANSPARENT,
    			"Layer Transparent", //$NON-NLS-1$
    			
    		 getFieldEditorParent(),32,255,64));
      
        */
        
        
       
        /*addField(new RadioGroupFieldEditor(
		        INITIAL_ZOOM,
				"initial_zoom", //$NON-NLS-1$
				4,
				new String[][] { {"1/16","0.0625"},{"1/8","0.125"},{"1/4","0.25"},{"1/2","0.5"},{"1","1"},{"2","2"},{"4","4"},{"8","8"}
			}, getFieldEditorParent()));
        
        
        FieldEditor editor=new SliderFieldEditor(
                JPEG_QUALITY,
    			"jpeg_quality(if you use high-quality,a file will be bigger than PNG)", //$NON-NLS-1$
    			
    		 getFieldEditorParent(),1,100,defaultJpegQuality);
        
        addField(editor);
        */
        
    }
	
	public void init(IWorkbench workbench) {
	}
}