/*
 * Created on 2004/11/13 Author aki@www.xucker.jpn.org License Apache2.0 or
 * Common Public License
 */
package org.jpn.xucker.subplayer;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;

import java.util.List;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.betwixt.io.BeanReader;
import org.apache.commons.betwixt.io.BeanWriter;
import org.apache.commons.betwixt.strategy.ConvertUtilsObjectStringConverter;
import org.apache.commons.lang.CharSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.commons.audio.JavaSoundAudioPlayer;
import org.jpn.xucker.commons.audio.TimerAudioStopper;
import org.jpn.xucker.commons.swt.ui.MenuItemContainer;
import org.jpn.xucker.commons.swt.ui.SWTBasicFileApplication;
import org.jpn.xucker.mp3.JavaLayerMP3Player;
import org.jpn.xucker.rcp.subplayer.compatibility.Mark;
import org.jpn.xucker.rcp.subplayer.compatibility.SubPlayFileXmlObject;
import org.jpn.xucker.subtitle.StandardSubObject;
import org.jpn.xucker.subtitle.SubUtils;
import org.jpn.xucker.subtitle.srt.SRTList;
import org.jpn.xucker.subtitle.srt.SRTParser;
import org.jpn.xucker.subtitle.sub.SUBParser;
import org.xml.sax.SAXException;

import java.beans.IntrospectionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SubPlayMain extends SWTBasicFileApplication implements
        SelectionListener, SubPlayFileUpdater, ShellListener ,Runnable{
    
    public  static Log log=
    LogFactory.getLog(SubPlayMain.class);
    
    /**
     * @param shell
     */
    
    private Button markButton;
    private Button markNext;
    private Button markPrev;
    
    private Button autoButton;

    private Button stopButton;

    private Button playButton;

    private Button nextButton;

    private Button prevButton;

    private Button firstButton;

    private Button lastButton;

    int index = 0;

    private SubPlayFileXmlObject subPlayFileXmlObject;

    /*
     * public class EListener implements MouseListener,Listener{
     *  /* (non-Javadoc)
     * @see org.eclipse.swt.widgets.Listener#handleEvent(org.eclipse.swt.widgets.Event)
     */
    /*
     * public void handleEvent(Event event) {
     * 
     * if(event.type==SWT.MouseUp){ // TODO Auto-generated method stub
     * System.out.println("event:"+event.button); event.doit=true;
     * 
     * System.out.println(event.widget); if(event.widget instanceof Control){
     * System.out.println("control"); Menu
     * menu=((Control)event.widget).getMenu();
     * 
     * if(menu!=null){ System.out.println("enable");
     * 
     * menu.setEnabled(false); menu.setVisible(false);
     * ((Control)event.widget).setMenu(null); MenuItem items[]=menu.getItems();
     * for(int i=0;i <items.length;i++){ items[i].setEnabled(false); }
     *  } }
     *  } } public void mouseDoubleClick(MouseEvent e) { // TODO Auto-generated
     * method stub
     *  }
     * 
     * 
     * public void mouseDown(MouseEvent e) { // TODO Auto-generated method stub
     *  }
     * 
     * 
     * public void mouseUp(MouseEvent e) {
     *  // TODO Auto-generated method stub System.out.println(e.button);
     *  }
     *  }
     */
    private String version = "0.6";

    private String HOMEPAGE_URL = "http://www.xucker.jpn.org/product/subplayer.html";

    private String APP_NAME = "akJ-SubPlayer";

    //private DvdsuptoolsList list;

    //private DvdsuptoolsObject[] datas;

    //private DvdsuptoolsList list2;

    //private DvdsuptoolsObject[] datas2;

    private List sublist1;

    private List sublist2;

    private ImageCanvas canvas;

    private ImageCanvas canvas2;

    private boolean autoPlay;

    private long lastPosition;

    private SubPlayPreferenceXmlObject preference;

    JavaSoundAudioPlayer audioPlayer;

    private TimerAudioStopper stopper;;

    private TitleUpdater titleUpdater;

    private ImageSetter imageSetter;

    private SubMainMenu mainMenu;

    private boolean preferenceChanged = false;

    private Shell subshell;

    private SubPlayMain self;

    private String preferencePath = "subplay_preference.conf";

    private Object totalTime;

    private Slider slider;

    private MarkControler markControler;
    
    
    public MarkControler getMarkControler(){
        return markControler;
    }
    
    public SubPlayMain(Shell shell) {
       
       
        self = this;

        shell.addShellListener(this);

        shell.setImage(new Image(Display.getCurrent(), SubPlayMain.class
                .getClassLoader().getResourceAsStream(
                        "org/jpn/xucker/subplayer/resource/icon.png")));

        this.shell = shell;
        shell.setText("");
        shell.setBounds(0, 0, 715, 570);
        RowLayout layout = new RowLayout();
        shell.setLayout(layout);
        autoButton = new Button(shell, SWT.NULL);

        autoButton.setText("autoPlay");
        autoButton.setImage(new Image(Display.getCurrent(), SubPlayMain.class
                .getClassLoader().getResourceAsStream(
                        "org/jpn/xucker/subplayer/resource/auto.png")));
        autoButton.addSelectionListener(this);
        RowData button1_data = new RowData();
        autoButton.setLayoutData(button1_data);

        playButton = new Button(shell, SWT.NULL);
        playButton.setText("play");
        playButton.setImage(new Image(Display.getCurrent(), this.getClass()
                .getClassLoader().getResourceAsStream(
                        "org/jpn/xucker/subplayer/resource/play.png")));
        playButton.addSelectionListener(this);

        stopButton = new Button(shell, SWT.NULL);
        stopButton.setText("stop");
        stopButton.setImage(new Image(Display.getCurrent(), SubPlayMain.class
                .getClassLoader().getResourceAsStream(
                        "org/jpn/xucker/subplayer/resource/stop.png")));
        stopButton.addSelectionListener(this);

        prevButton = new Button(shell, SWT.NULL);
        prevButton.setText("prev");
        prevButton.setImage(new Image(Display.getCurrent(), SubPlayMain.class
                .getClassLoader().getResourceAsStream(
                        "org/jpn/xucker/subplayer/resource/prev.png")));
        prevButton.addSelectionListener(this);

        nextButton = new Button(shell, SWT.NULL);
        nextButton.setText("next");
        nextButton.setImage(new Image(Display.getCurrent(), SubPlayMain.class
                .getClassLoader().getResourceAsStream(
                        "org/jpn/xucker/subplayer/resource/next.png")));
        nextButton.addSelectionListener(this);

        firstButton = new Button(shell, SWT.NULL);
        firstButton.setText("first");
        firstButton.setImage(new Image(Display.getCurrent(), SubPlayMain.class
                .getClassLoader().getResourceAsStream(
                        "org/jpn/xucker/subplayer/resource/first.png")));
        firstButton.addSelectionListener(this);

        lastButton = new Button(shell, SWT.NULL);
        lastButton.setText("last");
        lastButton.setImage(new Image(Display.getCurrent(), SubPlayMain.class
                .getClassLoader().getResourceAsStream(
                        "org/jpn/xucker/subplayer/resource/last.png")));
        lastButton.addSelectionListener(this);

        
        
        
        
        
        slider = new Slider(shell,SWT.HORIZONTAL);
        slider.setEnabled(false);
        slider.setMinimum(0);
        slider.setMaximum(1);
        slider.addSelectionListener(this);
        RowData sliderData=new RowData();
        sliderData.width=100;
        sliderData.height=16;
        slider.setLayoutData(sliderData);
        
        createMarkPanel(shell);
        markControler=new MarkControler(this,markButton);
        
        
        
        playButton.setFocus();
        
        canvas = new ImageCanvas(shell);
        RowData label_data = new RowData();
        canvas.setLayoutData(label_data);
        label_data.width = 700;
        label_data.height = 325;

        canvas2 = new ImageCanvas(shell);
        //canvas2.addListener(SWT.MouseUp,new EListener());

        Menu popup = new Menu(shell, SWT.POP_UP);
        MenuItem item = new MenuItem(popup, SWT.NULL);
        item.setText("ok");
        //canvas2.setMenu(popup);
        //canvas2.addMouseListener(new EListener());

        RowData sub2_data = new RowData();
        canvas2.setLayoutData(sub2_data);
        sub2_data.width = 700;
        sub2_data.height = 125;

       
        
        stopper = new TimerAudioStopper();
        

        titleUpdater = new TitleUpdater();
        imageSetter = new ImageSetter();

        mainMenu = new SubMainMenu(shell);
        MenuEventExecuter executer=new MenuEventExecuter();
        mainMenu.setExecuteObject(executer);

        MenuShortCut menuShortCut=new MenuShortCut(executer);
        
        //playButton.addKeyListener(menuShortCut);
        
        preference = new SubPlayPreferenceXmlObject();
        //writePreference(new File("c:\\tmp\\p.xml"));
        readPreference(new File(preferencePath));

        menuUpdate();
        updateButtons();
        modeDisable();

        
        
        
        //log.trace("play-focus:"+focus);
        Control[] controls=shell.getChildren();
        for (int i = 0; i < controls.length; i++) {
            if(! (controls[i] instanceof Canvas)){
            controls[i].addKeyListener(menuShortCut);
            }
        }
        
        
        Transfer[] types = new Transfer[] {FileTransfer.getInstance()};
    	
    	int operations = DND.DROP_MOVE | DND.DROP_COPY ;
    	
    	
    		
    	
    	
    	
    	
    		DropTarget target2 = new DropTarget (canvas, operations);
    		target2.setTransfer(types);
    	
    		target2.addDropListener(new DropMonitor());
    }

    public class DropMonitor extends DropTargetAdapter{
		public void dragEnter(DropTargetEvent event){
			//System.out.println("drag enter:"+event.data);
		}
		public void dragOver(DropTargetEvent event){
			//System.out.println("drag over:"+event.data);
			}
		public void drop(DropTargetEvent event){
			//System.out.println("drop:"+event.data);
			
			//System.out.println(event.data.getClass().getName());
			String files[]=(String[])event.data;
		
		
			for(int i=0;i<files.length;i++){
			    File file=new File(files[i]);
			    if(file.isFile()){
			        selectFile(file);
				
				break;
			    }
			}
			
			}
		
		public void selectFile(File file){
//		  check prev save.//TODO framework
	        if(isNeedSave()){
	            int result=askSave();
	            if(result==YES){
	            if(!saveFile()){
	                return; //cancel
	            }
	            }else if(result==CANCEL){
	                return;
	            }
	        }
	        setFile(file);
	        execOpen();//
		}
	}
    
    public void focusPlay(){
        boolean focus=playButton.setFocus();//focus.
        
    }
    
    public List getSublist(){
        return sublist1; //tmp
    }
    /**
     * @param shell
     */
    private void createMarkPanel(Shell shell) {
        // TODO Auto-generated method stub
        Canvas canvas=new Canvas(shell,SWT.NULL);
        canvas.setLayout(null);
        markButton=new Button(canvas,SWT.CHECK);
        markButton.addSelectionListener(this);
        markButton.setBounds(0,0,60,20);
        markButton.setText("Mark");
        
        markPrev=new Button(canvas,SWT.NULL);
        markPrev.setBounds(0,20,30,30);
        markPrev.setText("prev");
        markPrev.setEnabled(false);
        markPrev.addSelectionListener(this);
        
        markNext=new Button(canvas,SWT.NULL);
        markNext.setBounds(30,20,30,30);
        markNext.setText("next");
        markNext.setEnabled(false);
        
        markNext.addSelectionListener(this);
    }

    /**
     *  
     */
    private final void menuUpdate() {

        int margintime = preference.getMargintime();
        if (margintime == 0) {
            mainMenu.getMenuItem("m0").setSelection(true);
        } else if (margintime == 100) {
            mainMenu.getMenuItem("m1").setSelection(true);
        } else if (margintime == 150) {
            mainMenu.getMenuItem("m1p5").setSelection(true);
        } else if (margintime == 200) {
            mainMenu.getMenuItem("m2").setSelection(true);
        } else if (margintime == 250) {
            mainMenu.getMenuItem("m2p5").setSelection(true);
        } else if (margintime == 300) {
            mainMenu.getMenuItem("m3").setSelection(true);
        } else if (margintime == 400) {
            mainMenu.getMenuItem("m4").setSelection(true);
        } else if (margintime == 500) {
            mainMenu.getMenuItem("m5").setSelection(true);
        } else if (margintime == 1000) {
            mainMenu.getMenuItem("m10").setSelection(true);
        }

        int waittime = preference.getWaittime();
        if (waittime == 0) {
            mainMenu.getMenuItem("w0").setSelection(true);
        } else if (waittime == 1000) {
            mainMenu.getMenuItem("w1").setSelection(true);
        } else if (waittime == 3000) {
            mainMenu.getMenuItem("w3").setSelection(true);
        } else if (waittime == 10000) {
            mainMenu.getMenuItem("w10").setSelection(true);
        } else if (waittime == 15000) {
            mainMenu.getMenuItem("w15").setSelection(true);
        } else if (waittime == 30000) {
            mainMenu.getMenuItem("w30").setSelection(true);
        } else if (waittime == 45000) {
            mainMenu.getMenuItem("w45").setSelection(true);
        } else if (waittime == 60000) {
            mainMenu.getMenuItem("w60").setSelection(true);
        }

        mainMenu.getMenuItem("checkStartNew").setSelection(
                preference.isCreateNew());
        mainMenu.getMenuItem("checkPlayFirstSub").setSelection(
                preference.isPlayFirstSub());

        mainMenu.getMenuItem("checkPlaySecondSub").setSelection(
                preference.isPlaySecondSub());
        mainMenu.getMenuItem("checkPlaySound").setSelection(
                preference.isPlayFirstAudio());

        mainMenu.getMenuItem("checkRepeat").setSelection(preference.isRepeat());
        mainMenu.getMenuItem("checkReverse").setSelection(
                preference.isReverse());

    }

    private final void updateButtons() {
        setReverse(preference.isReverse());
    }

    public void setUpSubDatas() {
        index = 0;
        if (subPlayFileXmlObject != null) {
            if (subPlayFileXmlObject.getFirstSubFilePath() != null
                    && !subPlayFileXmlObject.getFirstSubFilePath().equals("")) {
                // list = DvdsuptoolsBuilder.parseSubData());
                sublist1 = loadSubData(new File(parsePath(subPlayFileXmlObject
                        .getFirstSubFilePath())));
                //datas = list.getSubOjects();

                if(sublist1!=null){
                totalTime = SubUtils
                        .toTimeString(SubUtils
                                .getTotalTime((StandardSubObject[]) sublist1
                                        .toArray(new StandardSubObject[sublist1
                                                .size()])));
                }else{
                    totalTime=SubUtils.toTimeString(0);
                }
            } else {
                //list=null;
                //datas=null;

                sublist1 = null;
                totalTime = null;
            }
            //	      Arrays.sort(datas);

            //	      list2 = SubDataBuilder.parseSubData(new
            // File(subFile2),SubDataBuilder.RELATIVE);

            if (subPlayFileXmlObject.getSecondSubFilePath() != null
                    && !subPlayFileXmlObject.getSecondSubFilePath().equals("")) {
                sublist2 = loadSubData(new File(parsePath(subPlayFileXmlObject
                        .getSecondSubFilePath())));

                // list2 = DvdsuptoolsBuilder.parseSubData(new
                // File(parsePath(subPlayFileXmlObject.getSecondSubFilePath())));

                // datas2 = list2.getSubOjects();
            } else {
                //   list2=null;
                //   datas2=null;

                sublist2 = null;
            }

        } else {
            sublist1 = null;
            sublist2 = null;
        }
    }
    
    private void errorMessage(String message){
        MessageBox box = new MessageBox(shell, SWT.OK | SWT.ICON_WARNING);
        box.setText("G[");
        box.setMessage(message);

        //int result=box.open();
        //never use result int,for PMD
        box.open();
    }

    private void errorFileNotFound(String path){
        errorMessage("t@C܂\r\n"+path);
    }
    /**
     * @param file
     * @return
     */
    private List loadSubData(File file) {
        if(file==null || !file.exists()){
            errorFileNotFound(file.getAbsolutePath());
            return null;
        }
        // TODO Auto-generated method stub
        int type = SubUtils.getSubType(file);
        if (type == SubUtils.SUB) {
            SUBParser parser=new SUBParser();
            parser.parse(file);
            

            return parser.getSubDataList();
        } else if (type == SubUtils.SRT) {
            SRTParser parser=new SRTParser();
            try {
                SRTList list=parser.parse(new FileReader(file));
                return list.getSubDataList();
            } catch (FileNotFoundException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            
        }
        return null;
    }

    public String parsePath(String path) {
        if (isAbsolutePath(path)) {
            return path;
        } else {
            File resultPath = new File(getFile().getParentFile(), path);
            return resultPath.getAbsolutePath();
        }
    }

    public boolean isAbsolutePath(String path) {
        if (path.startsWith("/")) {
            return true;
        }
        if (path.length() > 1) {
            if (CharSet.ASCII_ALPHA.contains(path.charAt(0))
                    && path.charAt(1) == ':') {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {

        Display display = new Display();
        Shell shell = new Shell(display, SWT.CLOSE | SWT.MIN);
        try {
            SubPlayMain main = new SubPlayMain(shell);

            shell.open();
          
            if (args.length > 0) {
                main.openArgFile(args[0]);
            } else {
                main.openNew();
            }
            while (!shell.isDisposed()) {
                if (!display.readAndDispatch()) {
                    display.sleep();
                }
            }
            display.dispose();
        } catch (Exception e) {
            e.printStackTrace();
            log.fatal(e.getMessage());
        } finally {
            if (!shell.isDisposed()) {
                shell.close();
            }
           
            display.dispose();
            System.exit(0);
        }

    }

    /**
     *  
     */
    private void openNew() {
        //System.out.println("opennew");
        if (preference.isCreateNew()) {
            execNew();
        }
    }

    
    
    /**
     * @param string
     */
    //TODO  mix openfile.
    public void openArgFile(String string) {
        if(log.isDebugEnabled()){
            log.debug("openFile()"+string);
        }
        setFile(new File(string));
        execOpen();
    }

    

    public void widgetSelected(SelectionEvent event) {
        Object target = event.getSource();
        if (target == null) {
            //maybe not happen.
           log.warn("target==null");
        }
        //null1
        else if (target == autoButton) {
            //do_button1();
            execAutoPlay();
            //mode play
        } else if (target == playButton) {
            //  do_button1();
            execPlay();
            //mode play
        } else if (target == nextButton) {
            //  do_button1();
            execNext();
            //mode play
        } else if (target == prevButton) {
            //  do_button1();
            execPrev();
            //mode play
        } else if (target == firstButton) {
            //  do_button1();
            execFirst();
            //mode play
        } else if (target == lastButton) {
            //  do_button1();
            execLast();
            //mode play
        } else if (target == stopButton) {
            //  do_button1();
            execStop();
        }else if (target == slider) {
            //  do_button1();
            execSlider();
        }else if (target == markButton) {
            //  do_button1();
            markCheck();
        }else if (target == markNext) {
            //  do_button1();
            markControler.next();
        }else if (target == markPrev) {
            //  do_button1();
            markControler.prev();
        }
    }

   

    /**
     * 
     */
    private void markCheck() {
        StandardSubObject currentObject=(StandardSubObject)sublist1.get(index);
        markControler.check(currentObject);
        if(markControler.canMove()){
            markPrev.setEnabled(true);
            markNext.setEnabled(true);
        }else{
            markPrev.setEnabled(false);
            markNext.setEnabled(false);
        }
    }

    /**
     * 
     */
    private void execSlider() {
       int value=slider.getSelection();
       if (value < sublist1.size() ) {
           index=value;
       }
       
       
       updateCanvas();
       updateTitle();
       //slider moved.
       
       updateMark();
    }

    private final void setReverse(boolean selection) {
        preference.setReverse(selection);
        if (selection) {
            autoButton.setImage(new Image(Display.getCurrent(),
                    SubPlayMain.class.getClassLoader().getResourceAsStream(
                            "org/jpn/xucker/subplayer/resource/auto2.png")));
        } else {
            autoButton.setImage(new Image(Display.getCurrent(),
                    SubPlayMain.class.getClassLoader().getResourceAsStream(
                            "org/jpn/xucker/subplayer/resource/auto.png")));
        }
    }

    private void execStop() {
        stopper.setStopped(true);
        //mode stop
        modeStop();
    }

    

    /**
     *  
     */
    public void modeStop() {
        log.debug("modestop()");
        autoPlay = false;
        // TODO Auto-generated method stub
        stopButton.setEnabled(false);
        autoButton.setEnabled(true);
        playButton.setEnabled(true);
        nextButton.setEnabled(true);
        prevButton.setEnabled(true);
        firstButton.setEnabled(true);
        lastButton.setEnabled(true);
        slider.setEnabled(true);
        
        slider.setSelection(index); //for auto play.
        
        lastPosition = 0;
        
        
        //re draw.
        updateCanvas();
        updateTitle();
        updateSlider();
        updateMark();
        
        focusPlay();
        
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
        // TODO Auto-generated method stub

    }

    /*
     * public void do_button1(){ //loadImage loadImage(datas[index]);
     * //playsound playSound(datas[index]); index++; if(index>datas.length){
     * index=0; } }
     */

    public void execAutoPlay() {
        autoPlay = true;
        modePlay();

        Thread t = new Thread(new Changer());
        t.start();

    }

    public void execNext() {
        if (index < sublist1.size() - 1) {
            index++;
        }
        updateCanvas();
        updateTitle();
        updateSlider();
        updateMark();
    }

    public void execPrev() {
        if (index > 0) {
            index--;
        }
        updateCanvas();
        updateTitle();
        updateSlider();
        updateMark();
    }

    public void execFirst() {
        index = 0;
        updateCanvas();
        updateTitle();
        updateSlider();
        updateMark();
    }
    
    
    public void updateMark(){
        if(sublist1!=null){
        if(sublist1.size()>0){
        boolean bool=markControler.isMarked((StandardSubObject)sublist1.get(index));
        markControler.setStatus(bool);
        if(bool){
            markControler.setCurrentMark(markControler.findMark((StandardSubObject)sublist1.get(index)));
        }
        }
        if(markControler.canMove()){
            markPrev.setEnabled(true);
            markNext.setEnabled(true);
        }
        }
    }
    
    public void moveFrame(Mark mark){
        StandardSubObject subs[]=(StandardSubObject[])sublist1.toArray(new StandardSubObject[sublist1.size()]);
        for(int i=0;i<subs.length;i++){
        if(subs[i].getStartTime()==mark.getStartTime()&&subs[i].getEndTime()==mark.getEndTime()){
            index=i;
            updateCanvas();
            updateTitle();
            updateSlider();
        }
        
        }
    }

    public void execLast() {
        if (sublist1 != null) {
            index = sublist1.size() - 1;
        }
        updateCanvas();
        updateTitle();
        updateSlider();
        updateMark();
    }

    
    public void execPlay() {
        log.debug("execPlay()");
        modePlay();
        log.debug("call thread()");
        Thread thread=new Thread(this);
        thread.start();
    }

    private void inPlay() {
        log.debug("inPlay()");
        if (subPlayFileXmlObject.getFirstWavFilePath() != null
                && !subPlayFileXmlObject.getFirstWavFilePath().equals("")) {
            try {
                playSound((StandardSubObject) sublist1.get(index));
            } catch (UnsupportedAudioFileException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            } catch (LineUnavailableException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
    }

    /**
     *  
     */
    private void modePlay() {
        stopButton.setEnabled(true);
        autoButton.setEnabled(false);
        playButton.setEnabled(false);
        nextButton.setEnabled(false);
        prevButton.setEnabled(false);
        firstButton.setEnabled(false);
        lastButton.setEnabled(false);
        slider.setEnabled(false);
    }
    
    private void modeDisable(){
        autoPlay = false;
        lastPosition = 0;
        stopButton.setEnabled(false);
        autoButton.setEnabled(false);
        playButton.setEnabled(false);
        nextButton.setEnabled(false);
        prevButton.setEnabled(false);
        firstButton.setEnabled(false);
        lastButton.setEnabled(false);
        stopButton.setEnabled(false);
        slider.setEnabled(false);
    }

    public void writePreference(File path) {

        try {
            BeanWriter writer = new BeanWriter(new FileWriter(path));
            writer
                    .writeXmlDeclaration("<?xml version=\"1.0\" encoding=\"Shift_Jis\"?>");
            writer.write(preference);
            writer.close();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (SAXException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IntrospectionException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

    }

    final public void readPreference(File file) {
        if (file.exists()) {
            try {
                //  XMLJavaBean쐬
                BeanReader reader = new BeanReader();
                reader.getBindingConfiguration().setObjectStringConverter(
                        new ConvertUtilsObjectStringConverter());
                reader.registerBeanClass(SubPlayPreferenceXmlObject.class);
                preference = (SubPlayPreferenceXmlObject) reader.parse(file);
            } catch (Exception e) {
                preference = new SubPlayPreferenceXmlObject();
                e.printStackTrace();
            }
        } else {
            preference = new SubPlayPreferenceXmlObject();
        }

    }

private File getFirstSubFileBaseDir(){
    return new File(parsePath(subPlayFileXmlObject
            .getFirstSubFilePath())).getParentFile();
    
}    

private File getSecondSubFileBaseDir(){
    return new File(parsePath(subPlayFileXmlObject
            .getSecondSubFilePath())).getParentFile();
    
} 

public void updateCanvas() {
        if (preference.isPlayFirstSub() && sublist1 != null
                && sublist1.size() > 0) {
            
            //have image.
            if(((StandardSubObject) sublist1.get(index)).getImagePath()!=null){
            File file = new File(getFirstSubFileBaseDir(),
                    ((StandardSubObject) sublist1.get(index)).getImagePath());
            //loadImage(datas[index]);
            		imageSetter.setFile(file);
            }else{
                imageSetter.setFile(null);
            }
            
            if(((StandardSubObject) sublist1.get(index)).getText()!=null){
                
                String text=((StandardSubObject) sublist1.get(index)).getText();
                canvas.setText(text);
                }else{
                    canvas.setText(null);
                }
            
            imageSetter.setImageCanvas(canvas);
            
            shell.getDisplay().syncExec(imageSetter);
        } else {
            canvas.setText(null);
            imageSetter.setImageCanvas(canvas);
            imageSetter.setFile(null);
            shell.getDisplay().syncExec(imageSetter);
        }

        //secondSub
        if (sublist1 != null && sublist1.size() > 0) {
            StandardSubObject sub = findSecondSub((StandardSubObject)sublist1.get(index));
            if (sub != null && preference.isPlaySecondSub()) {

                if(sub.getImagePath()!=null){
                File secondFile = new File(getSecondSubFileBaseDir(), sub
                        .getImagePath());
                //System.out.println("second:"+secondFile);
                imageSetter.setImageCanvas(canvas2);
                imageSetter.setFile(secondFile);
                }else{
                    imageSetter.setImageCanvas(canvas2);
                    imageSetter.setFile(null);
                }
                canvas2.setText(sub.getText());
                        
                
                shell.getDisplay().syncExec(imageSetter);

            } else {
                canvas2.setText(null);
                imageSetter.setImageCanvas(canvas2);
                imageSetter.setFile(null);
                shell.getDisplay().syncExec(imageSetter);

            }
        } else {
            canvas2.setText(null);
            imageSetter.setImageCanvas(canvas2);
            imageSetter.setFile(null);

            shell.getDisplay().syncExec(imageSetter);
        }
    }

    private StandardSubObject findSecondSub(StandardSubObject data) {
        if (sublist2 == null) {
            return null;
        }

        StandardSubObject result = null;
        long mutch = 0;
        for (int i = 0; i < sublist2.size(); i++) {
            long count = SubUtils.countContainTime(data,(StandardSubObject)sublist2.get(i));
            if (count > mutch) {
                result = (StandardSubObject)sublist2.get(i);
                mutch = count;
            }
            if (mutch != 0 && count == 0) {
                return result;
            }
        }

        return result;
    }

    public class Changer implements Runnable {

        public void run() {
            // TODO support loop
            while (autoPlay) {

                //loadImage

                updateCanvas();
                shell.getDisplay().syncExec(titleUpdater);
                //playsound
                //maybe should change audio valid.
                if (preference.isPlayFirstAudio()) {
                    inPlay();
                }

                int direction = 1;
                if (preference.isReverse()) {
                    direction = -1;
                }

                index += direction;

                if (index < 0 || index >= sublist1.size()) {
                    //updateCanvas();
                    //shell.getDisplay().syncExec(titleUpdater);

                    if (preference.isRepeat()) {
                        if (index < 0) {
                            index = sublist1.size() - 1;
                        } else {
                            index = 0;
                        }
                        lastPosition = 0;
                    } else {
                        if (index < 0) {
                            index = 0;
                        } else {
                            index = sublist1.size() - 1;
                        }
                        break;
                    }
                }
                try {
                    if (preference.getWaittime() > 0) {
                        Thread.sleep(preference.getWaittime());
                    }
                } catch (InterruptedException e) {

                    e.printStackTrace();
                }
            }
            MethodCommand modeStopCommand = new MethodCommand(self, "modeStop",
                    null);

            shell.getDisplay().syncExec(modeStopCommand);
            //modeStop();
        }

        /**
         * @param data
         * @return
         */

    }

    /**
     * @param data
     * @throws LineUnavailableException
     * @throws IOException
     * @throws UnsupportedAudioFileException
     */
    private void playSound(StandardSubObject data) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        log.debug("playsound()");
        stopper.setStopped(false);
        //maybe start thread.
        try {
            
            int margin = preference.getMargintime();
            /*BufferedInputStream finput = new BufferedInputStream(new  FileInputStream(new File(
                    parsePath(subPlayFileXmlObject.getFirstWavFilePath()))),10240);
            */
            
            FileInputStream finput = new  FileInputStream(new File(
                    parsePath(subPlayFileXmlObject.getFirstWavFilePath())));
            long start = Math.max(data.getStartTime()
                    - margin, 0);
         
            long end = data.getEndTime() + margin;
            //System.out.println("playSound:["+data.getFileName()+"]
            // "+SubDataList.toTimeString(start)+"-"+SubDataList.toTimeString(end));
            if(subPlayFileXmlObject.getFirstWavFilePath().toLowerCase().endsWith(".wav")){
            audioPlayer = new JavaSoundAudioPlayer();

            audioPlayer.setStopper(stopper);
           
            audioPlayer.play(finput, Math.max(lastPosition, start), end);
            }else if(subPlayFileXmlObject.getFirstWavFilePath().toLowerCase().endsWith(".mp3")){
                //audioPlayer = new MP3JavaSoundAudioPlayer(); 
                audioPlayer = new JavaLayerMP3Player(); 

                audioPlayer.setStopper(stopper);
               
                audioPlayer.play(new File(subPlayFileXmlObject.getFirstWavFilePath()), Math.max(lastPosition, start), end);
                
            }

            if (autoPlay && !preference.isReverse()) {
                lastPosition = end;
            }
        } catch (FileNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

    }

    /**
     * @param data
     */
    /*
     * private void loadImage(SubData data) { loadImage(new
     * File(list.getBaseDir(),data.getFileName())); }
     */

    private void loadImage(ImageCanvas imageCanvas, File imagePath) {
        try {
            if (imagePath != null) {
                Image img = new Image(shell.getDisplay(), new FileInputStream(
                        imagePath));
                imageCanvas.setImage(img);
                imageCanvas.redraw();
            } else {
                imageCanvas.setImage(null);
                imageCanvas.redraw();
            }
        } catch (FileNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

    }

    public class MethodCommand implements Runnable {
        private Object object;

        /**
         * @param self
         * @param string
         * @param object2
         */
        public MethodCommand(Object object, String method, Object[] args) {
            this.object = object;
            this.methodName = method;
            this.args = args;
        }

        public Object[] getArgs() {
            return args;
        }

        public void setArgs(Object[] args) {
            this.args = args;
        }

        public String getMethodName() {
            return methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public Object getObject() {
            return object;
        }

        public void setObject(Object object) {
            this.object = object;
        }

        private String methodName;

        private Object[] args;

        public void run() {
            try {
                MethodUtils.invokeMethod(object, methodName, args);
                // System.out.println("call stop");
            } catch (NoSuchMethodException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            } catch (IllegalAccessException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            } catch (InvocationTargetException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }

    }

    public class TitleUpdater implements Runnable {
        public void run() {
            updateTitle();
        }
    }

    public class ImageSetter implements Runnable {

        private File file;

        public File getFile() {
            return file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        private ImageCanvas imageCanvas;

        public ImageCanvas getImageCanvas() {
            return imageCanvas;
        }

        public void setImageCanvas(ImageCanvas imageCanvas) {
            this.imageCanvas = imageCanvas;
        }

        public ImageSetter() {

        }/*
          * public ImageSetter(File file,ImageCanvas imageCanvas){
          * this.file=file; this.imageCanvas=imageCanvas; }
          */

        /*
         * (non-Javadoc)
         * 
         * @see java.lang.Runnable#run()
         */
        public void run() {
            loadImage(imageCanvas, file);
        }

    }

    public void execHomepage() {
        Program program = Program.findProgram("html");
        if (program != null) {
            program.execute(HOMEPAGE_URL);
        }

    }

    public void execVersion() {
        MessageBox box = new MessageBox(shell, SWT.OK | SWT.ICON_INFORMATION);
        box.setMessage(APP_NAME + " v" + version + "\r\n\r\n"
                + "License CPL or Apache2.0\r\n (c)AbL[  2004\r\n"
                + HOMEPAGE_URL);

        //int result=box.open();
        //never use result int,for PMD
        box.open();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.jpn.xucker.commons.util.AbstractBasicFileApplication#execOpen()
     */
    protected void execOpen() {
        if (subshell != null && !subshell.isDisposed()) {
            subshell.close();
        }
        
        if(getFile().getName().toLowerCase().endsWith(".srt")){
        execOpenSrt();
        return;    
        }
            
        
        subPlayFileXmlObject = null;

        try {
            if(getFile().exists()){
            //      XMLJavaBean쐬
            BeanReader reader = new BeanReader();
            reader.registerBeanClass(SubPlayFileXmlObject.class);
            subPlayFileXmlObject = (SubPlayFileXmlObject) reader
                    .parse(getFile());

            setNeedSave(false);	//for drug & drop;
            updateDatas();
            
            }else{
                log.fatal("file not found "+getFile().getAbsolutePath());
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
        if (subPlayFileXmlObject == null) {
           setFile(null);
           sublist1=null;
           sublist2=null;
           modeDisable();
            
           
        }else{
            
//          load marks
            markControler.init();
            
            Mark marks[]=subPlayFileXmlObject.getMarks();
            if(marks!=null){
            for(int i=0;i<marks.length;i++){
                for(int j=0;j<sublist1.size();j++){
                    StandardSubObject sub=(StandardSubObject)sublist1.get(j);
                    if(marks[i].isMutch(sub)){
                        markControler.addMark(marks[i]);
                    }
                }
            }
            }
        }
        
        
        
        updateMark();
    }

    /**
     * 
     */
    private void execOpenSrt() {
        subPlayFileXmlObject=new SubPlayFileXmlObject();
        
            String path=getFile().getAbsolutePath();
            subPlayFileXmlObject.setFirstSubFilePath(path);
            String wavPath=path.substring(0,path.length()-4)+".wav";
            String mp3Path=path.substring(0,path.length()-4)+".mp3";
            if(new File(wavPath).exists()){
                subPlayFileXmlObject.setFirstWavFilePath(wavPath);
            }else if(new File(mp3Path).exists()){
                subPlayFileXmlObject.setFirstWavFilePath(mp3Path);
            }
            
            log.trace("execOpenSrt");
            setNeedSave(true);
            updateDatas();
            
        setFile(null);
    }

    private void errorInvalidXml(){
        MessageBox box = new MessageBox(shell, SWT.OK | SWT.ICON_WARNING);
        box.setMessage("XMĽ`Ⴂ܂B");

        //int result=box.open();
        //never use result int,for PMD
        box.open();
    }
    /*
     * (non-Javadoc)
     * 
     * @see org.jpn.xucker.commons.util.AbstractBasicFileApplication#execSave()
     */
    protected void execSave() {
        try {
            //synch mark.
            subPlayFileXmlObject.setMarks(markControler.getMarkArray());
            
            BeanWriter writer = new BeanWriter(new FileWriter(getFile()));
            writer
                    .writeXmlDeclaration("<?xml version=\"1.0\" encoding=\"Shift_Jis\"?>");
            writer.write(subPlayFileXmlObject);
            writer.close();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (SAXException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IntrospectionException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.jpn.xucker.commons.util.AbstractBasicFileApplication#updateTitle()
     */
    protected void updateTitle() {
        // TODO Auto-generated method stub
        String label = "";
        File file = getFile();
        if (file != null) {
            label = file.getName() + " ";
        }
        if (totalTime != null) {
            label += "[" + totalTime + "]" + " ";
        }
        if (sublist1 != null) {
            label += (index + 1) + "/" + sublist1.size();
        }

        log.trace("needSave:"+isNeedSave());
        if (isNeedSave()) {
            label = "* " + label;
        }
        shell.setText(label);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.jpn.xucker.commons.util.AbstractBasicFileApplication#execNew()
     */
    final protected void execNew() {
        subPlayFileXmlObject = new SubPlayFileXmlObject();

        updateDatas();
        modeDisable();

        // TODO Auto-generated method stub
        if (subshell == null || subshell.isDisposed()) {
            subshell = new Shell(shell);

            SubPlayFileXmlDialog dialog = new SubPlayFileXmlDialog(this,
                    subshell);
            subshell.open();
        } else {
            subshell.setActive();
        }

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.jpn.xucker.commons.util.AbstractBasicFileApplication#execExit()
     */
    public void execExit() {

        if(log.isDebugEnabled()){
            log.debug("execExit()");
        }
        shell.close();
    }

    public void edit() {

        if (subPlayFileXmlObject != null) {
            // TODO Auto-generated method stub
            if (subshell == null || subshell.isDisposed()) {
                subshell = new Shell(shell);
                SubPlayFileXmlDialog dialog = new SubPlayFileXmlDialog(this,
                        subshell);
                try {
                    BeanUtils.copyProperties(dialog, subPlayFileXmlObject);
                } catch (IllegalAccessException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                } catch (InvocationTargetException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
                subshell.open();
            } else {
                subshell.setActive();
            }
        }
    }

    /**
     *  
     */
    private void savePreference() {
        writePreference(new File(preferencePath));
        preferenceChanged = false;
    }

    public class MenuEventExecuter {

        public void do_newz(MenuItemContainer menuItemContainer) {
            newFile();
        }

        public void do_open(MenuItemContainer menuItemContainer) {
            if (!stopButton.isEnabled()) {
                openFile();
            }
        }

        public void do_save(MenuItemContainer menuItemContainer) {
            if (!stopButton.isEnabled()) {
                saveFile();
            }
        }

        public void do_saveAs(MenuItemContainer menuItemContainer) {
            if (!stopButton.isEnabled()) {
                saveAsFile();
            }
        }

        public void do_edit(MenuItemContainer menuItemContainer) {
            if (!stopButton.isEnabled()) {
                edit();
            }
        }

        public void do_export(MenuItemContainer menuItemContainer) {
        }

        public void do_exit(MenuItemContainer menuItemContainer) {
            execExit();
        }

        public void do_autoplay(MenuItemContainer menuItemContainer) {
            if (!stopButton.isEnabled()) {
                execAutoPlay();
            }
        }

        public void do_play(MenuItemContainer menuItemContainer) {
            if (!stopButton.isEnabled()) {
                execPlay();
            }
        }

        public void do_stop(MenuItemContainer menuItemContainer) {
            if (stopButton.isEnabled()) {
                execStop();
            }
        }

        public void do_prev(MenuItemContainer menuItemContainer) {
            if (!stopButton.isEnabled()) {
                execPrev();
            }
        }

        public void do_next(MenuItemContainer menuItemContainer) {
            if (!stopButton.isEnabled()) {
                execNext();
            }
        }

        public void do_first(MenuItemContainer menuItemContainer) {
            if (!stopButton.isEnabled()) {
                execFirst();
            }
        }

        public void do_last(MenuItemContainer menuItemContainer) {
            if (!stopButton.isEnabled()) {
                execLast();
            }
        }

        public void do_checkStartNew(MenuItemContainer menuItemContainer) {
            preferenceChanged = true;
            preference.setCreateNew(menuItemContainer.getMenuItem(
                    "checkStartNew").getSelection());
        }

        public void do_checkPlaySound(MenuItemContainer menuItemContainer) {
            preferenceChanged = true;
            preference.setPlayFirstAudio(menuItemContainer.getMenuItem(
                    "checkPlaySound").getSelection());
        }

        public void do_checkPlayFirstSub(MenuItemContainer menuItemContainer) {
            preferenceChanged = true;
            preference.setPlayFirstSub(menuItemContainer.getMenuItem(
                    "checkPlayFirstSub").getSelection());
            updateCanvas();
        }

        public void do_checkPlaySecondSub(MenuItemContainer menuItemContainer) {
            preferenceChanged = true;
            preference.setPlaySecondSub(menuItemContainer.getMenuItem(
                    "checkPlaySecondSub").getSelection());
            updateCanvas();
        }

        public void do_checkRepeat(MenuItemContainer menuItemContainer) {
            preferenceChanged = true;
            preference.setRepeat(menuItemContainer.getMenuItem("checkRepeat")
                    .getSelection());
        }

        public void do_checkReverse(MenuItemContainer menuItemContainer) {
            preferenceChanged = true;
            setReverse(menuItemContainer.getMenuItem("checkReverse")
                    .getSelection());

        }

        /**
         * @param selection
         */

        public void do_w0(MenuItemContainer menuItemContainer) {
            preferenceChanged = true;
            preference.setWaittime(0);
        }

        public void do_w1(MenuItemContainer menuItemContainer) {
            preferenceChanged = true;
            preference.setWaittime(1 * 1000);
        }

        public void do_w3(MenuItemContainer menuItemContainer) {
            preferenceChanged = true;
            preference.setWaittime(3 * 1000);
        }

        public void do_w10(MenuItemContainer menuItemContainer) {
            preferenceChanged = true;
            preference.setWaittime(10 * 1000);
        }

        public void do_w15(MenuItemContainer menuItemContainer) {
            preferenceChanged = true;
            preference.setWaittime(15 * 1000);
        }

        public void do_w30(MenuItemContainer menuItemContainer) {
            preferenceChanged = true;
            preference.setWaittime(30 * 1000);
        }

        public void do_w45(MenuItemContainer menuItemContainer) {
            preferenceChanged = true;
            preference.setWaittime(45 * 1000);
        }

        public void do_w60(MenuItemContainer menuItemContainer) {
            preferenceChanged = true;
            preference.setWaittime(60 * 1000);
        }

        public void do_m0(MenuItemContainer menuItemContainer) {
            preferenceChanged = true;
            preference.setMargintime(0);
        }

        public void do_m1p5(MenuItemContainer menuItemContainer) {
            preferenceChanged = true;
            preference.setMargintime(150);

        }

        public void do_m2p5(MenuItemContainer menuItemContainer) {
            preferenceChanged = true;
            preference.setMargintime(250);

        }

        public void do_m1(MenuItemContainer menuItemContainer) {
            preferenceChanged = true;
            preference.setMargintime(100);
        }

        public void do_m2(MenuItemContainer menuItemContainer) {
            preferenceChanged = true;
            preference.setMargintime(200);
        }

        public void do_m3(MenuItemContainer menuItemContainer) {
            preferenceChanged = true;
            preference.setMargintime(300);
        }

        public void do_m4(MenuItemContainer menuItemContainer) {
            preferenceChanged = true;
            preference.setMargintime(400);
        }

        public void do_m5(MenuItemContainer menuItemContainer) {
            preferenceChanged = true;
            preference.setMargintime(500);
        }

        public void do_m10(MenuItemContainer menuItemContainer) {
            preferenceChanged = true;
            preference.setMargintime(1000);
        }

        public void do_about(MenuItemContainer menuItemContainer) {
            execVersion();
        }

        public void do_homepage(MenuItemContainer menuItemContainer) {
            execHomepage();
        }
        
        public void do_export_audio(MenuItemContainer menuItemContainer) {
            execExportAudio();
        }

       

    }

    /**
     * 
     */
    private void execExportAudio() {
        // TODO Auto-generated method stub
        //create and open dialog
        Shell exportAudioShell=new Shell(shell); //if already open.active only.
        SubPlayExportAudioDialog dialog=new SubPlayExportAudioDialog(this,exportAudioShell);
        exportAudioShell.open();
        //modable.
        //execute.
    }
    public SubPlayFileXmlObject getSubPlayFileXmlObject() {
        return subPlayFileXmlObject;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.jpn.xucker.subplayer.SubPlayFileUpdater#update(org.jpn.xucker.subplayer.SubPlayFileXmlDialog)
     */
    public void update(SubPlayFileXmlDialog dialog) {
        //new version

        /*
         * SubPlayFileXmlObject xmlObject=updater.getSubPlayFileXmlObject();
         * xmlObject.setFirstSubFilePath(firstSub.getAbsoluteFilePath());
         * xmlObject.setSecondSubFilePath(secondSub.getAbsoluteFilePath());
         * xmlObject.setFirstWavFilePath(firstWav.getAbsoluteFilePath());
         */
        SubPlayFileXmlObject tmpObject = new SubPlayFileXmlObject();
        try {
            BeanUtils.copyProperties(tmpObject, dialog);
            //System.out.println(tmpObject.getFirstSubFilePath());
        } catch (IllegalAccessException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        if (!subPlayFileXmlObject.equals(tmpObject)) {
            // System.out.println("need save");
            setNeedSave(true);
            try {
                BeanUtils.copyProperties(subPlayFileXmlObject, tmpObject);
            } catch (IllegalAccessException e1) {
                // TODO Auto-generated catch block
                e1.printStackTrace();
            } catch (InvocationTargetException e1) {
                // TODO Auto-generated catch block
                e1.printStackTrace();
            }
        }

        //edit version
        updateDatas();

    }

    public void updateDatas() {

        setUpSubDatas();
        updateCanvas();
        updateTitle();
        updateSlider();
        
        if (sublist1 != null && sublist1.size() > 0) {

            modeStop();

            if (!preference.isReverse()) {
                index = 0;
            } else {
                index = sublist1.size() - 1;
            }

        }else{
            modeDisable();
        }
    }

    /**
     * 
     */
    private void updateSlider() {
        if(sublist1!=null && sublist1.size()>0){
            slider.setMaximum(sublist1.size());
            slider.setSelection(index);
            slider.setEnabled(true);
            
        }else{
            slider.setEnabled(false);
        }
        
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.swt.events.ShellListener#shellActivated(org.eclipse.swt.events.ShellEvent)
     */
    public void shellActivated(ShellEvent e) {
        // TODO Auto-generated method stub

    }

    public void shellClosed(ShellEvent event) {
        //System.out.println("shell closed");
        if (isNeedSave()) {
            if (isNeedSave()) {
                int result = askSave();
                if (result == YES) {
                    if (!saveFile()) {
                        event.doit = false;
                        return; //cancel
                    }
                } else if (result == CANCEL) {
                    event.doit = false;
                    return;
                }
            }
        }
        event.doit = true;
        /* do finally */
        stopper.setStopped(true);
        autoPlay = false;
        if (preferenceChanged) {
            //
            //System.out.println("save preference");
            savePreference();
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.swt.events.ShellListener#shellDeactivated(org.eclipse.swt.events.ShellEvent)
     */
    public void shellDeactivated(ShellEvent e) {
        // TODO Auto-generated method stub

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.swt.events.ShellListener#shellDeiconified(org.eclipse.swt.events.ShellEvent)
     */
    public void shellDeiconified(ShellEvent e) {
        // TODO Auto-generated method stub

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.swt.events.ShellListener#shellIconified(org.eclipse.swt.events.ShellEvent)
     */
    public void shellIconified(ShellEvent e) {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see java.lang.Runnable#run()
     */
    public void run() {
        log.debug("run");
        inPlay();
        shell.getDisplay().syncExec(modeStop);
    }
    
    ModeStop modeStop=new ModeStop();
    public class ModeStop implements Runnable{

        /* (non-Javadoc)
         * @see java.lang.Runnable#run()
         */
        public void run() {
            modeStop();
        }
        
    }

    /* (non-Javadoc)
     * @see org.jpn.xucker.commons.util.AbstractBasicFileApplication#saveStatusChanged()
     */
    protected void saveStatusChanged() {
        // TODO Auto-generated method stub
        
    }

}

