/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.ICategory;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.ExtendedSite;
import org.eclipse.update.internal.core.LiteFeature;
import org.eclipse.update.internal.search.BaseSearchCategory;
import org.eclipse.update.search.IQueryUpdateSiteAdapter;
import org.eclipse.update.search.IUpdateSearchFilter;
import org.eclipse.update.search.IUpdateSearchQuery;
import org.eclipse.update.search.IUpdateSearchResultCollector;

public class SiteSearchCategory
extends BaseSearchCategory {
    private IUpdateSearchQuery[] queries = new IUpdateSearchQuery[]{new Query()};
    private boolean liteFeaturesAreOK;
    private static final String CATEGORY_ID = "org.eclipse.update.core.unified-search";

    public SiteSearchCategory() {
        super(CATEGORY_ID);
    }

    public SiteSearchCategory(boolean liteFeaturesAreOK) {
        this();
        this.liteFeaturesAreOK = liteFeaturesAreOK;
        this.queries = new IUpdateSearchQuery[]{new Query(liteFeaturesAreOK)};
    }

    public IUpdateSearchQuery[] getQueries() {
        return this.queries;
    }

    public boolean isLiteFeaturesAreOK() {
        return this.liteFeaturesAreOK;
    }

    public void setLiteFeaturesAreOK(boolean liteFeaturesAreOK) {
        this.liteFeaturesAreOK = liteFeaturesAreOK;
        int i = 0;
        while (i < this.queries.length) {
            ((Query)this.queries[i]).setLiteFeaturesAreOK(liteFeaturesAreOK);
            ++i;
        }
    }

    private static class FeatureDownloader
    implements Runnable {
        private List siteFeatureReferences;
        private IProgressMonitor monitor;
        private IUpdateSearchFilter filter;
        private IUpdateSearchResultCollector collector;
        private HashSet ignores;
        private boolean liteFeaturesAreOK;
        private Map liteFeatures;

        private FeatureDownloader() {
        }

        public FeatureDownloader(List siteFeatureReferences, IUpdateSearchResultCollector collector, IUpdateSearchFilter filter, HashSet ignores, IProgressMonitor monitor) {
            this.collector = collector;
            this.filter = filter;
            this.ignores = ignores;
            this.monitor = monitor;
            this.siteFeatureReferences = siteFeatureReferences;
        }

        public FeatureDownloader(List siteFeatureReferences, IUpdateSearchResultCollector collector, IUpdateSearchFilter filter, HashSet ignores, IProgressMonitor monitor, boolean liteFeaturesAreOK, Map liteFeatures) {
            this(siteFeatureReferences, collector, filter, ignores, monitor);
            this.liteFeaturesAreOK = liteFeaturesAreOK && liteFeatures != null;
            this.liteFeatures = liteFeatures;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            ISiteFeatureReference siteFeatureReference = null;
            while (this.siteFeatureReferences.size() != 0) {
                Object var5_8;
                List list = this.siteFeatureReferences;
                synchronized (list) {
                    siteFeatureReference = this.siteFeatureReferences.size() != 0 ? (ISiteFeatureReference)this.siteFeatureReferences.remove(0) : null;
                }
                if (siteFeatureReference == null) continue;
                boolean skipFeature = false;
                if (this.monitor.isCanceled()) {
                    return;
                }
                if (this.ignores.size() > 0) {
                    ICategory[] categories = siteFeatureReference.getCategories();
                    int j = 0;
                    while (j < categories.length) {
                        ICategory category = categories[j];
                        if (this.ignores.contains(category.getName())) {
                            skipFeature = true;
                            break;
                        }
                        ++j;
                    }
                }
                try {
                    block19: {
                        try {
                            if (skipFeature || !this.filter.accept(siteFeatureReference)) break block19;
                            IFeature feature = null;
                            if (this.liteFeaturesAreOK) {
                                feature = (IFeature)this.liteFeatures.get(siteFeatureReference.getVersionedIdentifier());
                            }
                            if (feature == null) {
                                feature = siteFeatureReference.getFeature(null);
                            }
                            List list2 = this.siteFeatureReferences;
                            synchronized (list2) {
                                if (feature != null && this.filter.accept(siteFeatureReference)) {
                                    this.collector.accept(feature);
                                    this.monitor.subTask(feature.getLabel());
                                }
                            }
                        }
                        catch (CoreException e) {
                            System.out.println((Object)e);
                        }
                    }
                    var5_8 = null;
                }
                catch (Throwable throwable) {
                    var5_8 = null;
                    this.monitor.worked(1);
                    throw throwable;
                }
                this.monitor.worked(1);
            }
        }
    }

    private static class Query
    implements IUpdateSearchQuery {
        private boolean liteFeaturesAreOK;

        public Query() {
            this.liteFeaturesAreOK = false;
        }

        public Query(boolean liteFeaturesAreOK) {
            this.liteFeaturesAreOK = liteFeaturesAreOK;
        }

        public boolean isLiteFeaturesAreOK() {
            return this.liteFeaturesAreOK;
        }

        public void setLiteFeaturesAreOK(boolean liteFeaturesAreOK) {
            this.liteFeaturesAreOK = liteFeaturesAreOK;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(ISite site, String[] categoriesToSkip, IUpdateSearchFilter filter, IUpdateSearchResultCollector collector, IProgressMonitor monitor) {
            ISiteFeatureReference[] refs = site.getFeatureReferences();
            HashSet<String> ignores = new HashSet<String>();
            HashMap<VersionedIdentifier, LiteFeature> liteFeatures = new HashMap<VersionedIdentifier, LiteFeature>();
            if (categoriesToSkip != null) {
                int i = 0;
                while (i < categoriesToSkip.length) {
                    ignores.add(categoriesToSkip[i]);
                    ++i;
                }
            }
            ArrayList<ISiteFeatureReference> siteFeatureReferences = new ArrayList<ISiteFeatureReference>(Arrays.asList(refs));
            if (this.liteFeaturesAreOK && site instanceof ExtendedSite) {
                ExtendedSite extendedSite = (ExtendedSite)site;
                LiteFeature[] liteFeaturesArray = extendedSite.getLiteFeatures();
                if (liteFeaturesArray != null && liteFeaturesArray.length != 0) {
                    int i = 0;
                    while (i < liteFeaturesArray.length) {
                        liteFeatures.put(liteFeaturesArray[i].getVersionedIdentifier(), liteFeaturesArray[i]);
                        ++i;
                    }
                    new FeatureDownloader(siteFeatureReferences, collector, filter, ignores, monitor, true, liteFeatures).run();
                    return;
                }
                this.liteFeaturesAreOK = false;
            }
            monitor.beginTask("", refs.length);
            ThreadGroup featureDownloaders = new ThreadGroup("FeatureDownloader");
            int numberOfThreads = refs.length > 5 ? 5 : refs.length;
            int i2 = 0;
            while (i2 < numberOfThreads) {
                Thread featureDownloader = new Thread(featureDownloaders, new FeatureDownloader(siteFeatureReferences, collector, filter, ignores, monitor));
                featureDownloader.start();
                ++i2;
            }
            while (featureDownloaders.activeCount() != 0) {
                if (monitor.isCanceled()) {
                    ArrayList<ISiteFeatureReference> i2 = siteFeatureReferences;
                    synchronized (i2) {
                        siteFeatureReferences.clear();
                    }
                }
                Thread[] temp = new Thread[featureDownloaders.activeCount()];
                featureDownloaders.enumerate(temp);
                if (temp[0] == null) continue;
                try {
                    temp[0].join(250L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        }

        public IQueryUpdateSiteAdapter getQuerySearchSite() {
            return null;
        }
    }
}

