/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.dropsomething;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.dropsomething.DropsomethingTab;
import jp.sourceforge.akjrcp.dropsomething.DropsomethingView;
import jp.sourceforge.akjrcp.dropsomething.ProgressAndList;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.util.FFMpegExecuter;
import jp.sourceforge.akjrcp.util.FLVTool2Executer;
import jp.sourceforge.akjrcp.util.FileNameUtils;
import jp.sourceforge.akjrcp.util.FlowPlayerHtml;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class FLVConvertTab
extends DropsomethingTab {
    private Composite controler;
    private StackLayout stack;
    private FLVConvertTab self;
    private ProgressAndList plist;
    ViewPart view;
    private CCombo videoSize;
    private FFMpegExecuter executer;
    private CCombo audioRate;
    private CCombo videoRate;
    private CCombo videoBitRate;
    private CCombo audioBitRate;
    private CCombo audioChannel;
    private Button flowplayerHtml;
    private Button flowplayerSWF;
    private Button avisynth;
    private Button flvtool2;
    private boolean callFLVTool2;
    private boolean copyFlowPlayerSWF;
    private boolean copyFlowPlayerHTML;
    private boolean exportFLVFile;
    private boolean copySWFHTML;
    private Button swfHtml;
    private boolean cancelling;
    private Button exportSWF;
    private Button exportFLV;

    private void createLabel(Composite composite, String label) {
        Label label1 = new Label(composite, 0);
        label1.setText(label);
    }

    public FLVConvertTab(ViewPart view, Composite parent, int style) {
        super(parent, style);
        this.view = view;
        this.self = this;
        this.stack = new StackLayout();
        this.setLayout((Layout)this.stack);
        this.controler = new Composite((Composite)this, 0);
        this.controler.setLayout((Layout)new GridLayout(2, true));
        IPreferenceStore store = Akj_betasPlugin.getDefault().getPreferenceStore();
        this.createLabel(this.controler, Messages.getString("flvconvert.video_size"));
        this.videoSize = new CCombo(this.controler, 0);
        this.videoSize.add("320x240");
        this.videoSize.add("640x480");
        this.videoSize.setText(store.getString("flvconvert.video_size"));
        this.createLabel(this.controler, Messages.getString("flvconvert.frame_rate"));
        this.videoRate = new CCombo(this.controler, 0);
        this.videoRate.add("30");
        this.videoRate.add("29.7");
        this.videoRate.add("25");
        this.videoRate.add("15");
        this.videoRate.setText(store.getString("flvconvert.video_rate"));
        this.createLabel(this.controler, Messages.getString("flvconvert.video_bitrate"));
        this.videoBitRate = new CCombo(this.controler, 0);
        this.videoBitRate.add("4000");
        this.videoBitRate.add("3000");
        this.videoBitRate.add("2000");
        this.videoBitRate.add("1500");
        this.videoBitRate.add("1000");
        this.videoBitRate.add("500");
        this.videoBitRate.setText(store.getString("flvconvert.video_bitrate"));
        this.createLabel(this.controler, Messages.getString("flvconvert.audio_rate"));
        this.audioRate = new CCombo(this.controler, 8);
        this.audioRate.add("44100");
        this.audioRate.add("22050");
        this.audioRate.add("11025");
        this.audioRate.setText(store.getString("flvconvert.audio_rate"));
        this.createLabel(this.controler, Messages.getString("flvconvert.audio_bitrate"));
        this.audioBitRate = new CCombo(this.controler, 0);
        this.audioBitRate.add("256");
        this.audioBitRate.add("192");
        this.audioBitRate.add("128");
        this.audioBitRate.add("96");
        this.audioBitRate.add("64");
        this.audioBitRate.setText(store.getString("flvconvert.audio_bitrate"));
        this.createLabel(this.controler, Messages.getString("flvconvert.audio_channel"));
        this.audioChannel = new CCombo(this.controler, 8);
        this.audioChannel.add("1");
        this.audioChannel.add("2");
        this.audioChannel.select(store.getInt("flvconvert.audio_channel") - 1);
        this.createLabel(this.controler, Messages.getString("flvconvert.export_file_type"));
        Composite typeComposite = new Composite(this.controler, 0);
        typeComposite.setLayout((Layout)new GridLayout(2, true));
        this.exportFLV = new Button(typeComposite, 16);
        this.exportFLV.setText(Messages.getString("flvconvert.export_file_type_flv"));
        this.exportFLV.setSelection(true);
        this.exportFLV.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FLVConvertTab.this.updateExportSettingButtons();
            }
        });
        this.exportSWF = new Button(typeComposite, 16);
        this.exportSWF.setText(Messages.getString("flvconvert.export_file_type_swf"));
        this.exportSWF.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FLVConvertTab.this.updateExportSettingButtons();
            }
        });
        this.avisynth = new Button(this.controler, 32);
        this.avisynth.setText(Messages.getString("flvconvert.use_avisynth"));
        this.avisynth.setSelection(store.getBoolean("flvconvert.use_avisynth"));
        this.avisynth.setToolTipText(Messages.getString("flvconvert.use_avisynth_tooltip"));
        new Label(this.controler, 0);
        this.flowplayerHtml = new Button(this.controler, 32);
        this.flowplayerHtml.setText(Messages.getString("flvconvert.copy_html"));
        this.flowplayerHtml.setSelection(store.getBoolean("flvconvert.flowplayer_html"));
        this.flowplayerSWF = new Button(this.controler, 32);
        this.flowplayerSWF.setText(Messages.getString("flvconvert.copy_swf"));
        this.flowplayerSWF.setSelection(store.getBoolean("flvconvert.flowplayer_swf"));
        this.flvtool2 = new Button(this.controler, 32);
        this.flvtool2.setText(Messages.getString("flvconvert.use_flvtool2"));
        this.flvtool2.setToolTipText(Messages.getString("flvconvert.use_flvtool2_tooltip"));
        this.flvtool2.setSelection(store.getBoolean("flvconvert.use_flvtool2"));
        new Label(this.controler, 0);
        this.swfHtml = new Button(this.controler, 32);
        this.swfHtml.setText(Messages.getString("flvconvert.copy_swf_html"));
        this.updateExportSettingButtons();
        Transfer[] types = new Transfer[]{FileTransfer.getInstance()};
        int operations = 3;
        DropTarget target2 = new DropTarget((Control)this.controler, operations);
        target2.setTransfer(types);
        target2.addDropListener((DropTargetListener)new DropMonitor());
        this.plist = new ProgressAndList(this, 0);
        this.plist.getSimpleFileList().setInput(view);
        this.plist.getCancelButton().addSelectionListener((SelectionListener)new Cancel());
        this.stack.topControl = this.controler;
    }

    private void updateExportSettingButtons() {
        if (this.exportSWF.getSelection()) {
            this.flowplayerHtml.setEnabled(false);
            this.flowplayerSWF.setEnabled(false);
            this.flvtool2.setEnabled(false);
            this.swfHtml.setEnabled(true);
        } else {
            this.flowplayerHtml.setEnabled(true);
            this.flowplayerSWF.setEnabled(true);
            this.flvtool2.setEnabled(true);
            this.swfHtml.setEnabled(false);
        }
    }

    public void startConvert() {
        String ffmpegPath = Akj_betasPlugin.getDefault().getPreferenceStore().getString("ffmpeg_path");
        if (!FFMpegUtils.isFFMpegAvailable(ffmpegPath)) {
            return;
        }
        this.plist.getSimpleFileList().getTable().select(0);
        this.executer = new FFMpegExecuter(ffmpegPath, Akj_betasPlugin.getDefault().getProcessPrinter());
        this.executer.setVideoBitrate(Integer.parseInt(this.videoBitRate.getText()));
        this.executer.setVideoRate(Double.parseDouble(this.videoRate.getText()));
        this.executer.setVideoSize(this.videoSize.getText());
        this.executer.setAudioChannel(Integer.parseInt(this.audioChannel.getText()));
        this.executer.setAudioBitrate(Integer.parseInt(this.audioBitRate.getText()));
        this.executer.setAudioSampleRate(Integer.parseInt(this.audioRate.getText()));
        this.executer.setUseAvisynth(this.avisynth.getSelection());
        this.callFLVTool2 = this.flvtool2.getSelection();
        this.copyFlowPlayerHTML = this.flowplayerHtml.getSelection();
        this.copyFlowPlayerSWF = this.flowplayerSWF.getSelection();
        this.exportFLVFile = this.exportFLV.getSelection();
        this.copySWFHTML = this.swfHtml.getSelection();
        Thread t = new Thread(new ConvertFile());
        t.start();
    }

    public void addDragAndDropFile(String path) {
        if (this.stack.topControl == this.controler) {
            this.stack.topControl = this.plist;
            this.plist.addFile(path);
            this.layout();
            this.startConvert();
        } else {
            this.plist.addFile(path);
            this.layout();
        }
    }

    public Composite createControls(Composite parent) {
        return new Composite(parent, 0);
    }

    public void inconvert(File file) {
    }

    public void beforeConvert() {
    }

    public void afterConvert() {
    }

    public void cancelConvert() {
    }

    public class Cancel
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            FLVConvertTab.this.cancelling = true;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class ConvertFile
    implements Runnable {
        public void run() {
            boolean avsAvailable = FFMpegUtils.isAvisynthAvailable(new File(FLVConvertTab.this.executer.getFfmpegPath()));
            while (true) {
                File outputHTML;
                boolean result;
                boolean useAvisynth;
                int size;
                if ((size = FLVConvertTab.this.plist.getSimpleFileList().countFiles()) == 0 || FLVConvertTab.this.cancelling) break;
                File file = FLVConvertTab.this.plist.getSimpleFileList().getFileList()[0];
                String output = null;
                output = FLVConvertTab.this.exportFLVFile ? FileNameUtils.getChangedExtensionName(file, "flv") : FileNameUtils.getChangedExtensionName(file, "swf");
                File tmp = null;
                boolean bl = useAvisynth = avsAvailable && FLVConvertTab.this.executer.isUseAvisynth() && FFMpegUtils.shouldUseAvisynth(file);
                if (useAvisynth) {
                    try {
                        tmp = File.createTempFile("avs", ".avs");
                        FileWriter writer = new FileWriter(tmp);
                        writer.write(FFMpegUtils.toAVSScript(file.getAbsolutePath()));
                        writer.close();
                        FLVConvertTab.this.executer.setInput(tmp);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    FLVConvertTab.this.executer.setInput(file);
                }
                FLVConvertTab.this.executer.setOutput(new File(output));
                try {
                    FLVConvertTab.this.executer.execute();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (useAvisynth && !(result = tmp.delete())) {
                    DropsomethingView.log.warn((Object)("tmp not deleted:" + tmp));
                }
                if (FLVConvertTab.this.callFLVTool2 && FLVConvertTab.this.exportFLVFile) {
                    String path = Akj_betasPlugin.getDefault().getPreferenceStore().getString("flvtool2_path");
                    DropsomethingView.log.info((Object)path);
                    if (path.endsWith("flvtool2.exe")) {
                        FLVTool2Executer flvtool2Executer = new FLVTool2Executer(path, Akj_betasPlugin.getDefault().getProcessPrinter());
                        flvtool2Executer.setInput(new File(output));
                        try {
                            flvtool2Executer.execute();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (FLVConvertTab.this.exportFLVFile) {
                    File flowPlayerFile;
                    File outputFile;
                    File outputSWF;
                    if (FLVConvertTab.this.copyFlowPlayerSWF && !(outputSWF = new File((outputFile = new File(output)).getParent(), "FlowPlayer.swf")).exists() && (flowPlayerFile = new File(Akj_betasPlugin.getDefault().flowPlayerDir, "FlowPlayer.swf")).exists()) {
                        try {
                            FileUtils.copyFile((File)flowPlayerFile, (File)outputSWF);
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (FLVConvertTab.this.copyFlowPlayerHTML) {
                        outputFile = new File(output);
                        outputHTML = new File(FileNameUtils.getChangedExtensionName(outputFile, "html"));
                        FlowPlayerHtml fhtml = new FlowPlayerHtml(outputFile.getName(), null);
                        try {
                            FileUtils.writeStringToFile((File)outputHTML, (String)fhtml.toHTML().replaceAll("\n", "\r\n"), (String)"SJIS");
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                } else if (FLVConvertTab.this.copySWFHTML) {
                    File outputFile = new File(output);
                    outputHTML = new File(FileNameUtils.getChangedExtensionName(outputFile, "html"));
                    try {
                        String baseHtml = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/jp/sourceforge/akjrcp/dropsomething/resource/swf.html"));
                        String replaceHtml = StringUtils.replace((String)baseHtml, (String)"$swfPath", (String)outputFile.getName());
                        replaceHtml = StringUtils.replace((String)replaceHtml, (String)"$width", (String)("" + FLVConvertTab.this.executer.getVideoWidth()));
                        replaceHtml = StringUtils.replace((String)replaceHtml, (String)"$height", (String)("" + FLVConvertTab.this.executer.getVideoHeight()));
                        FileUtils.writeStringToFile((File)outputHTML, (String)replaceHtml);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                FLVConvertTab.this.plist.getSimpleFileList().popFile();
                FLVConvertTab.this.view.getSite().getShell().getDisplay().asyncExec((Runnable)new UpdateTable());
            }
            FLVConvertTab.this.view.getSite().getShell().getDisplay().asyncExec((Runnable)new FinishConvert());
        }
    }

    public class FinishConvert
    implements Runnable {
        public void run() {
            ((FLVConvertTab)FLVConvertTab.this).stack.topControl = FLVConvertTab.this.controler;
            FLVConvertTab.this.layout();
        }
    }

    public class UpdateTable
    implements Runnable {
        public void run() {
            FLVConvertTab.this.plist.getSimpleFileList().refresh(true);
            FLVConvertTab.this.plist.getSimpleFileList().getTable().select(0);
        }
    }

    public class DropMonitor
    extends DropTargetAdapter {
        public void dragEnter(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            String[] files = (String[])event.data;
            int i = 0;
            while (i < files.length) {
                FLVConvertTab.this.addDragAndDropFile(files[i]);
                ++i;
            }
        }
    }
}

