/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.dropsomething;

import java.io.File;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.audio.MP3AudioSettingComposite;
import jp.sourceforge.akjrcp.dropsomething.DirectoryBasedDropSomething;
import jp.sourceforge.akjrcp.dropsomething.IDropSomething;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegExecuter;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.ffmpeg.MP3FFMpegPreference;
import jp.sourceforge.akjrcp.ui.DirectryBasedExecuterListener;
import jp.sourceforge.akjrcp.ui.FileOverwriteControler;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MP3ConvertTabBuilder
implements IDropSomething {
    private FileOverwriteControler fileOverwriteControler;
    private CTabFolder tab;

    public void createTab(ViewPart part, CTabFolder tab) {
        CTabItem tabItem1 = new CTabItem(tab, 0);
        tabItem1.setText(Messages.getString("dropsomething.mp3audio"));
        tabItem1.setControl((Control)new MP3ConvertTab((Composite)tab, 0));
        this.tab = tab;
    }

    public class MP3ConvertTab
    extends DirectoryBasedDropSomething {
        private FFMpegExecuter ffmpegExecuter;
        private CLabel dragHere;
        private Button forceConvert;
        private Button quickCopy;
        private CCombo defaultBitrate;
        private MP3AudioSettingComposite mp3setting;

        public MP3ConvertTab(Composite parent, int style) {
            super(parent, style);
        }

        public Composite createControls(Composite parent) {
            this.setPreferenceKey("mp3converttab");
            this.getPreferenceStore().setDefault(String.valueOf(this.getPreferenceKey()) + "." + "quickcopy", true);
            this.getPreferenceStore().setDefault(String.valueOf(this.getPreferenceKey()) + "." + "forceconvert", false);
            this.getPreferenceStore().setDefault(String.valueOf(this.getPreferenceKey()) + "." + "audioBitrate", "128");
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, true));
            this.createDirectoryInfo(composite);
            Group detailSetting = new Group(composite, 0);
            detailSetting.setLayout((Layout)new FillLayout());
            detailSetting.setLayoutData((Object)new GridData(1808));
            detailSetting.setText(Messages.getString("mp3convert.detail"));
            ExpandBar bar = new ExpandBar((Composite)detailSetting, 512);
            Composite copybase = new Composite((Composite)bar, 0);
            copybase.setLayout((Layout)new RowLayout());
            this.quickCopy = new Button(copybase, 32);
            this.quickCopy.setText(Messages.getString("mp3convert.quickcopy"));
            ExpandItem item0 = new ExpandItem(bar, 0, 0);
            item0.setText(Messages.getString("mp3convert.aboutcopy"));
            item0.setHeight(copybase.computeSize((int)-1, (int)-1).y);
            item0.setControl((Control)copybase);
            Composite advancedSetting = new Composite((Composite)bar, 0);
            advancedSetting.setLayout((Layout)new GridLayout(1, false));
            Composite changebase = new Composite(advancedSetting, 0);
            changebase.setLayout((Layout)new RowLayout());
            this.forceConvert = new Button(changebase, 32);
            this.forceConvert.setText(Messages.getString("mp3convert.forceconvert"));
            this.mp3setting = new MP3AudioSettingComposite(changebase, 0, false, this.getPreferenceKey());
            ExpandItem item1 = new ExpandItem(bar, 0, 1);
            item1.setText(Messages.getString("mp3convert.convertsetting"));
            item1.setHeight(advancedSetting.computeSize((int)-1, (int)-1).y);
            item1.setControl((Control)advancedSetting);
            Composite bitrateBase = new Composite((Composite)bar, 0);
            bitrateBase.setLayout((Layout)new RowLayout());
            Label label1 = new Label(bitrateBase, 0);
            label1.setText(Messages.getString("mp3convert.defaultBitrate"));
            this.defaultBitrate = new CCombo(bitrateBase, 0);
            int[] bitrates = new int[]{64, 80, 96, 112, 128, 160, 192, 224, 256, 320};
            int i = 0;
            while (i < bitrates.length) {
                this.defaultBitrate.add("" + bitrates[i]);
                ++i;
            }
            this.defaultBitrate.select(4);
            Label label = new Label(bitrateBase, 0);
            label.setText("kbps");
            ExpandItem item2 = new ExpandItem(bar, 0, 2);
            item2.setText(Messages.getString("mp3convert.optionbitrate"));
            item2.setHeight(bitrateBase.computeSize((int)-1, (int)-1).y);
            item2.setControl((Control)bitrateBase);
            this.forceConvert.addSelectionListener((SelectionListener)new SynchEnabled(this.mp3setting));
            ImageDescriptor dandd = AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.akjrcp.akj_betas", (String)"icons/dandd.png");
            this.dragHere = new CLabel(composite, 18432);
            this.dragHere.setBackground(ColorConstants.white);
            this.dragHere.setImage(dandd.createImage());
            this.dragHere.setAlignment(0x1000000);
            this.dragHere.setLayoutData((Object)new GridData(768));
            SavePreferenceStore sps = new SavePreferenceStore();
            this.restoreControl((Control)this.forceConvert);
            this.restoreControl((Control)this.quickCopy);
            this.restoreControl((Control)this.defaultBitrate);
            this.forceConvert.addSelectionListener((SelectionListener)sps);
            this.quickCopy.addSelectionListener((SelectionListener)sps);
            this.defaultBitrate.addSelectionListener((SelectionListener)sps);
            this.mp3setting.setEnabled(this.forceConvert.getSelection());
            this.mp3setting.setPreferenceStore(this.getPreferenceStore());
            this.setCanConvert(true);
            this.updateStatus();
            return composite;
        }

        public void restoreControl(Control control) {
            IPreferenceStore store = this.getPreferenceStore();
            if (control == this.forceConvert) {
                this.forceConvert.setSelection(store.getBoolean(String.valueOf(this.getPreferenceKey()) + "." + "forceconvert"));
            } else if (control == this.quickCopy) {
                System.out.println(String.valueOf(this.getPreferenceKey()) + "." + "quickcopy" + "=" + store.getBoolean(String.valueOf(this.getPreferenceKey()) + "." + "quickcopy"));
                this.quickCopy.setSelection(store.getBoolean(String.valueOf(this.getPreferenceKey()) + "." + "quickcopy"));
            } else if (control == this.defaultBitrate) {
                String value = store.getString(String.valueOf(this.getPreferenceKey()) + "." + "defaultBitrate");
                int s = this.defaultBitrate.getItemCount();
                int i = 0;
                while (i < s) {
                    if (this.defaultBitrate.getItem(i).equals(value)) {
                        this.defaultBitrate.select(i);
                        break;
                    }
                    ++i;
                }
            }
        }

        public IPreferenceStore getPreferenceStore() {
            return Akj_betasPlugin.getDefault().getPreferenceStore();
        }

        public void storeControl(Control control) {
            IPreferenceStore store = this.getPreferenceStore();
            if (control == this.forceConvert) {
                store.setValue(String.valueOf(this.getPreferenceKey()) + "." + "forceconvert", this.forceConvert.getSelection());
            } else if (control == this.quickCopy) {
                store.setValue(String.valueOf(this.getPreferenceKey()) + "." + "quickcopy", this.quickCopy.getSelection());
            } else if (control == this.defaultBitrate) {
                store.setValue(String.valueOf(this.getPreferenceKey()) + "." + "defaultBitrate", this.defaultBitrate.getItem(this.defaultBitrate.getSelectionIndex()));
            }
        }

        public void inconvert(File file) {
            this.ffmpegExecuter.execute(new File[]{file});
        }

        public void beforeConvert() {
            MP3ConvertTabBuilder.this.fileOverwriteControler = new FileOverwriteControler(MP3ConvertTabBuilder.this.tab.getShell());
            this.ffmpegExecuter = new FFMpegExecuter();
            this.ffmpegExecuter.setExecuteListener(new FFMpegMonitor());
            String ffmpegPath = Akj_betasPlugin.getDefault().getPreferenceStore().getString("ffmpeg_path");
            MP3FFMpegPreference preference = new MP3FFMpegPreference();
            this.ffmpegExecuter.setFfmpegPreference(preference);
            this.ffmpegExecuter.setUseAvisynth(true);
            preference.setFfmpegPath(ffmpegPath);
            preference.setExtension("mp3");
            this.ffmpegExecuter.setSameDirectory(this.samefolder.getSelection());
            this.ffmpegExecuter.setBackup(this.backup.getSelection());
            if (!this.samefolder.getSelection()) {
                this.ffmpegExecuter.setExportDir(this.directoryChooser.getAbsoluteFilePath());
            }
            preference.setForceConvert(this.forceConvert.getSelection());
            preference.setUseCopy(this.quickCopy.getSelection());
            preference.setDefaultBitrate(Integer.parseInt(this.defaultBitrate.getItem(this.defaultBitrate.getSelectionIndex())));
            preference.setConvertBitrate(this.mp3setting.getBitrate());
            preference.setConvertFramerate(this.mp3setting.getFramerate());
            preference.setConvertChannel(this.mp3setting.getChannel());
        }

        public void afterConvert() {
            MP3ConvertTabBuilder.this.fileOverwriteControler = null;
        }

        public boolean isCanConvert() {
            String ffmpegPath = Akj_betasPlugin.getDefault().getPreferenceStore().getString("ffmpeg_path");
            return FFMpegUtils.isFFMpegAvailable(ffmpegPath);
        }

        public void cancelConvert() {
            this.ffmpegExecuter.cancel();
        }

        public void updateStatus() {
            if (this.samefolder.getSelection() || this.directoryChooser.getFile() != null) {
                this.setMessage(Messages.getString("dropsomething.drag_folder"));
                this.setCanConvert(true);
            } else {
                this.setErrorMessage(Messages.getString("dropsomething.choose_folder"));
                this.setCanConvert(false);
            }
        }

        public void setMessage(String text) {
            if (this.dragHere != null) {
                this.dragHere.setForeground(new Color(null, 64, 255, 64));
                this.dragHere.setText(text);
            }
        }

        public void setErrorMessage(String text) {
            if (this.dragHere != null) {
                this.dragHere.setForeground(new Color(null, 255, 0, 0));
                this.dragHere.setText(text);
            }
        }

        public class SynchEnabled
        implements SelectionListener {
            private Composite target;

            public SynchEnabled(Composite target) {
                this.target = target;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.target.setEnabled(((Button)e.getSource()).getSelection());
            }

            public void widgetSelected(SelectionEvent e) {
                this.target.setEnabled(((Button)e.getSource()).getSelection());
            }
        }

        public class SavePreferenceStore
        implements SelectionListener {
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MP3ConvertTab.this.storeControl((Control)e.getSource());
            }
        }

        public class FFMpegMonitor
        implements DirectryBasedExecuterListener {
            public void beforeConvert() {
            }

            public void afterConvert() {
            }

            public void startConvert(File file) {
            }

            public void endConvert(File file) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("[complete:mpeg]" + file.getAbsolutePath());
            }

            public void faildConvert(File file, String message) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("[faild:mpeg]" + message + "," + file.getAbsolutePath());
            }

            public void printProcess(String line) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printError(line);
            }

            public boolean askOverwrite(File output) {
                return FileOverwriteControler.askOverwrite(MP3ConvertTabBuilder.this.fileOverwriteControler, output);
            }
        }
    }
}

