/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.util.ArrayList;

public class FFMpegPreference {
    private String ffmpegPath;
    private String audioCodec;
    private int audioBitrate;
    private int audioRate;
    private int audioChannel;
    private String videoCodec;
    private double videoRate;
    private int videoBitrate;
    private int videoMinBitrate;
    private int videoMaxBitrate;
    private String videoSize;
    private String videoAspect;
    private String target;
    private boolean enableVideo = true;
    private boolean enableAudio = true;
    public static final int AUDIO_RATE_8000 = 8000;
    public static final int AUDIO_RATE_11025 = 11025;
    public static final int AUDIO_RATE_12000 = 12000;
    public static final int AUDIO_RATE_16000 = 16000;
    public static final int AUDIO_RATE_22050 = 22050;
    public static final int AUDIO_RATE_24000 = 24000;
    public static final int AUDIO_RATE_32000 = 32000;
    public static final int AUDIO_RATE_44100 = 44100;
    public static final int AUDIO_RATE_48000 = 48000;
    public static final double VIDEO_RATE_29_97 = 29.97;
    public static final double VIDEO_RATE_30 = 30.0;
    public static final double VIDEO_RATE_15 = 15.0;
    public static final String COPY = "copy";
    public static final String OPTION_INPUT = "-i";
    public static final String OPTION_OVERWRITE = "-y";
    public static final String OPTION_AUDIO_CODEC = "-acodec";
    public static final String OPTION_AUDIO_RATE = "-ar";
    public static final String OPTION_AUDIO_BITRATE = "-ab";
    public static final String OPTION_AUDIO_CHANNEL = "-ac";
    public static final String OPTION_DISABLE_AUDIO = "-an";
    public static final String OPTION_DISABLE_VIDEO = "-vn";
    public static final String OPTION_VIDEO_CODEC = "-vcodec";
    public static final String OPTION_VIDEO_RATE = "-r";
    public static final String OPTION_VIDEO_BITRATE = "-b";
    public static final String OPTION_VIDEO_MIN_BITRATE = "-minrate";
    public static final String OPTION_VIDEO_MAX_BITRATE = "-maxrate";
    public static final String OPTION_VIDEO_BUFFER_SIZE = "-bufsize";
    public static final String OPTION_VIDEO_SIZE = "-s";
    public static final String OPTION_VIDEO_ASPECT = "-aspect";
    public static final int AUDIO_CHANNEL_STEREO = 2;
    public static final int AUDIO_CHANNEL_MONORAL = 1;
    public static final String VIDEO_SIZE_320x240 = "320x240";
    public static final String VIDEO_SIZE_640x480 = "640x480";
    public static final String VIDEO_SIZE_720x480 = "720x480";
    public static final String VIDEO_SIZE_704x480 = "704x480";
    public static final String VIDEO_SIZE_752x480 = "352x480";
    public static final String VIDEO_SIZE_352x240 = "352x240";
    public static final String VIDEO_ASPECT_4x3 = "4:3";
    public static final String VIDEO_ASPECT_16x9 = "16:9";
    public static final String EXTENSION_MP3 = "mp3";
    public static final String EXTENSION_MPEG = "mpg";
    public static final String EXTENSION_AVI = "avi";
    public static final String OPTION_TARGET = "-target";
    public static final String TARGET_NTSC_DVD = "ntsc-dvd";
    private String extension;
    private boolean forceOverwrite = true;

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String[] toCommand(String input, String avs, String output) {
        if (input == null || output == null) {
            return null;
        }
        ArrayList<String> params = new ArrayList<String>();
        if (this.ffmpegPath == null) {
            params.add("ffmpeg");
        } else {
            params.add(this.ffmpegPath);
        }
        if (this.forceOverwrite) {
            params.add(OPTION_OVERWRITE);
        }
        params.add(OPTION_INPUT);
        if (avs == null) {
            params.add(input);
        } else {
            params.add(avs);
        }
        if (this.target != null) {
            params.add(OPTION_TARGET);
            params.add(TARGET_NTSC_DVD);
        }
        if (this.enableAudio) {
            if (this.valid(this.audioCodec)) {
                params.add(OPTION_AUDIO_CODEC);
                params.add(this.audioCodec);
            }
            if (this.audioRate != 0) {
                params.add(OPTION_AUDIO_RATE);
                params.add("" + this.audioRate);
            }
            if (this.audioBitrate != 0) {
                params.add(OPTION_AUDIO_BITRATE);
                params.add("" + this.audioBitrate);
            }
            if (this.audioChannel != 0) {
                params.add(OPTION_AUDIO_CHANNEL);
                params.add("" + this.audioChannel);
            }
        } else {
            params.add(OPTION_DISABLE_AUDIO);
        }
        if (this.enableVideo) {
            if (this.valid(this.videoCodec)) {
                params.add(OPTION_VIDEO_CODEC);
                params.add(this.videoCodec);
            }
            if (this.videoRate != 0.0) {
                params.add(OPTION_VIDEO_RATE);
                params.add("" + this.videoRate);
            }
            if (this.videoBitrate != 0) {
                params.add(OPTION_VIDEO_BITRATE);
                params.add(this.videoBitrate + "k");
            }
            if (this.videoMaxBitrate != 0) {
                params.add(OPTION_VIDEO_MAX_BITRATE);
                params.add(this.videoMaxBitrate + "k");
                params.add(OPTION_VIDEO_BUFFER_SIZE);
                params.add(this.videoMaxBitrate + 2 + "k");
            }
            if (this.videoMinBitrate != 0) {
                params.add(OPTION_VIDEO_MIN_BITRATE);
                params.add(this.videoMinBitrate + "k");
            }
            if (this.valid(this.videoSize)) {
                params.add(OPTION_VIDEO_SIZE);
                params.add(this.videoSize);
            }
            if (this.valid(this.videoAspect)) {
                params.add(OPTION_VIDEO_ASPECT);
                params.add(this.videoAspect);
            }
        } else {
            params.add(OPTION_DISABLE_VIDEO);
        }
        params.add(output);
        return params.toArray(new String[0]);
    }

    private boolean valid(String param) {
        return param != null && param.length() > 0;
    }

    public int getAudioBitrate() {
        return this.audioBitrate;
    }

    public void setAudioBitrate(int audioBitrate) {
        this.audioBitrate = audioBitrate;
    }

    public int getAudioChannel() {
        return this.audioChannel;
    }

    public void setAudioChannel(int audioChannel) {
        this.audioChannel = audioChannel;
    }

    public String getAudioCodec() {
        return this.audioCodec;
    }

    public void setAudioCodec(String audioCodec) {
        this.audioCodec = audioCodec;
    }

    public int getAudioRate() {
        return this.audioRate;
    }

    public void setAudioRate(int audioRate) {
        this.audioRate = audioRate;
    }

    public String getFfmpegPath() {
        return this.ffmpegPath;
    }

    public void setFfmpegPath(String ffmpegPath) {
        this.ffmpegPath = ffmpegPath;
    }

    public String getVideoAspect() {
        return this.videoAspect;
    }

    public void setVideoAspect(String videoAspect) {
        this.videoAspect = videoAspect;
    }

    public int getVideoBitrate() {
        return this.videoBitrate;
    }

    public void setVideoBitrate(int videoBitrate) {
        this.videoBitrate = videoBitrate;
    }

    public String getVideoCodec() {
        return this.videoCodec;
    }

    public void setVideoCodec(String videoCodec) {
        this.videoCodec = videoCodec;
    }

    public double getVideoRate() {
        return this.videoRate;
    }

    public void setVideoRate(double videoRate) {
        this.videoRate = videoRate;
    }

    public String getVideoSize() {
        return this.videoSize;
    }

    public void setVideoSize(String videoSize) {
        this.videoSize = videoSize;
    }

    public int getVideoMaxBitrate() {
        return this.videoMaxBitrate;
    }

    public void setVideoMaxBitrate(int videoMaxBitrate) {
        this.videoMaxBitrate = videoMaxBitrate;
    }

    public int getVideoMinBitrate() {
        return this.videoMinBitrate;
    }

    public void setVideoMinBitrate(int videoMinBitrate) {
        this.videoMinBitrate = videoMinBitrate;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public boolean isEnableAudio() {
        return this.enableAudio;
    }

    public void setEnableAudio(boolean enableAudio) {
        this.enableAudio = enableAudio;
    }

    public boolean isEnableVideo() {
        return this.enableVideo;
    }

    public void setEnableVideo(boolean enableVideo) {
        this.enableVideo = enableVideo;
    }
}

